/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordConstants;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Verse;

public class RawBackend
extends AbstractBackend {
    private boolean active;
    private static final Logger log;
    private RandomAccessFile[] idxRaf = new RandomAccessFile[3];
    private RandomAccessFile[] txtRaf = new RandomAccessFile[3];
    private File[] idxFile = new File[3];
    private File[] txtFile = new File[3];
    private static final int ENTRY_SIZE = 6;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RawBackend(SwordBookMetaData sbmd) throws BookException {
        super(sbmd);
        String path = this.getExpandedDataPath();
        this.idxFile[1] = new File(path + File.separator + "ot" + ".vss");
        this.txtFile[1] = new File(path + File.separator + "ot");
        this.idxFile[2] = new File(path + File.separator + "nt" + ".vss");
        this.txtFile[2] = new File(path + File.separator + "nt");
        if (!this.txtFile[1].canRead() && !this.txtFile[2].canRead()) {
            throw new BookException((MsgBase)Msg.MISSING_FILE, new Object[]{path});
        }
    }

    public final void activate(Lock lock) {
        if (this.idxFile[1].canRead()) {
            try {
                this.idxRaf[1] = new RandomAccessFile(this.idxFile[1], "r");
                this.txtRaf[1] = new RandomAccessFile(this.txtFile[1], "r");
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open OT", (Throwable)ex);
                this.idxRaf[1] = null;
                this.txtRaf[1] = null;
            }
        }
        if (this.idxFile[2].canRead()) {
            try {
                this.idxRaf[2] = new RandomAccessFile(this.idxFile[2], "r");
                this.txtRaf[2] = new RandomAccessFile(this.txtFile[2], "r");
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open NT", (Throwable)ex);
                this.idxRaf[2] = null;
                this.txtRaf[2] = null;
            }
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        try {
            this.idxRaf[1].close();
            this.txtRaf[1].close();
            this.idxRaf[2].close();
            this.txtRaf[2].close();
        }
        catch (IOException ex) {
            log.error("Failed to close files", (Throwable)ex);
        }
        finally {
            this.idxRaf[1] = null;
            this.txtRaf[1] = null;
            this.idxRaf[2] = null;
            this.txtRaf[2] = null;
        }
        this.active = false;
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        String charset = this.getBookMetaData().getBookCharset();
        Verse verse = KeyUtil.getVerse(key);
        try {
            int testament = SwordConstants.getTestament(verse);
            long index = SwordConstants.getIndex(verse);
            if (this.idxRaf[testament] == null) {
                return "";
            }
            byte[] read = SwordUtil.readRAF(this.idxRaf[testament], index * 6L, 6);
            if (read == null || read.length == 0) {
                return "";
            }
            long start = SwordUtil.decodeLittleEndian32(read, 0);
            int size = SwordUtil.decodeLittleEndian16(read, 4);
            if (size < 0) {
                log.error("In " + this.getBookMetaData().getInitials() + ": Verse " + verse.getName() + " has a bad index size of " + size);
            }
            byte[] data = SwordUtil.readRAF(this.txtRaf[testament], start, size);
            this.decipher(data);
            return SwordUtil.decode(key, data, charset);
        }
        catch (IOException ex) {
            throw new BookException(Msg.READ_FAIL, ex, new Object[]{verse.getName()});
        }
    }

    public Key readIndex() {
        return null;
    }

    public boolean isSupported() {
        return true;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !RawBackend.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)RawBackend.class);
    }
}

