/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;

public class MsgBase {
    private String name;
    private static Map resourceMap = new HashMap();
    private ResourceBundle resources;
    private static final Logger log = Logger.getLogger(MsgBase.class);

    protected MsgBase(String name) {
        this.name = name;
        this.loadResources();
    }

    public String toString() {
        try {
            if (this.resources != null) {
                return this.resources.getString(this.name);
            }
        }
        catch (MissingResourceException ex) {
            log.error("Missing resource: Locale=" + Locale.getDefault().toString() + " name=" + this.name + " package=" + this.getClass().getName());
        }
        return this.name;
    }

    public String toString(Object param) {
        return MessageFormat.format(this.toString(), param);
    }

    public String toString(Object[] params) {
        return MessageFormat.format(this.toString(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadResources() {
        Class<?> implementingClass = this.getClass();
        String className = implementingClass.getName();
        Class clazz = MsgBase.class;
        synchronized (clazz) {
            this.resources = (ResourceBundle)resourceMap.get(className);
            if (this.resources == null) {
                Locale defaultLocale = Locale.getDefault();
                try {
                    this.resources = ResourceBundle.getBundle(className, defaultLocale, CWClassLoader.instance(implementingClass));
                    resourceMap.put(className, this.resources);
                }
                catch (MissingResourceException ex) {
                    log.warn("Assuming key is the default message " + className + ": " + this.name);
                }
            }
        }
    }
}

