/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.IndexKey;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;

public class ZLDBackend
extends AbstractBackend {
    private static final String EXTENSION_INDEX = ".idx";
    private static final String EXTENSION_DATA = ".dat";
    private static final String EXTENSION_Z_INDEX = ".zdx";
    private static final String EXTENSION_Z_DATA = ".zdt";
    private static final int IDX_ENTRY_SIZE = 8;
    private static final int ZDX_ENTRY_SIZE = 8;
    private static final int BLOCK_ENTRY_COUNT = 4;
    private static final int BLOCK_ENTRY_SIZE = 8;
    private static final byte SEPARATOR = 10;
    private static final Logger log = Logger.getLogger((Class)ZLDBackend.class);
    private File idxFile;
    private File datFile;
    private File zdxFile;
    private File zdtFile;
    private RandomAccessFile idxRaf;
    private RandomAccessFile datRaf;
    private RandomAccessFile zdxRaf;
    private RandomAccessFile zdtRaf;
    private boolean active;
    private Key keys;
    private int lastBlockNum = -1;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] lastUncompressed = EMPTY_BYTES;

    public ZLDBackend(SwordBookMetaData sbmd) throws BookException {
        super(sbmd);
        String path = this.getExpandedDataPath();
        this.idxFile = new File(path + EXTENSION_INDEX);
        this.datFile = new File(path + EXTENSION_DATA);
        this.zdxFile = new File(path + EXTENSION_Z_INDEX);
        this.zdtFile = new File(path + EXTENSION_Z_DATA);
        if (!this.idxFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.idxFile.getAbsolutePath()});
        }
        if (!this.datFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.datFile.getAbsolutePath()});
        }
        if (!this.zdxFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.zdxFile.getAbsolutePath()});
        }
        if (!this.zdtFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.zdtFile.getAbsolutePath()});
        }
    }

    public final void activate(Lock lock) {
        try {
            this.idxRaf = new RandomAccessFile(this.idxFile, "r");
            this.datRaf = new RandomAccessFile(this.datFile, "r");
            this.zdxRaf = new RandomAccessFile(this.zdxFile, "r");
            this.zdtRaf = new RandomAccessFile(this.zdtFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.idxRaf = null;
            this.datRaf = null;
            this.zdxRaf = null;
            this.zdtRaf = null;
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        try {
            if (this.idxRaf != null) {
                this.idxRaf.close();
            }
            if (this.datRaf != null) {
                this.datRaf.close();
            }
            if (this.zdxRaf != null) {
                this.zdxRaf.close();
            }
            if (this.zdtRaf != null) {
                this.zdtRaf.close();
            }
        }
        catch (IOException ex) {
            log.error("failed to close nt files", (Throwable)ex);
        }
        finally {
            this.idxRaf = null;
            this.datRaf = null;
            this.zdxRaf = null;
            this.zdtRaf = null;
        }
        this.active = false;
    }

    public Key readIndex() {
        long entries;
        this.checkActive();
        SwordBookMetaData bmd = this.getBookMetaData();
        String charset = bmd.getBookCharset();
        this.keys = new DefaultKeyList(null, bmd.getName());
        boolean isDailyDevotional = bmd.getBookCategory().equals(BookCategory.DAILY_DEVOTIONS);
        GregorianCalendar greg = new GregorianCalendar(1972, 0, 1);
        SimpleDateFormat nameDF = new SimpleDateFormat("d MMMM");
        try {
            entries = this.idxRaf.length() / 8L;
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
            return this.keys;
        }
        int entry = 0;
        while ((long)entry < entries) {
            try {
                byte[] buffer = SwordUtil.readRAF(this.idxRaf, entry * 8, 8);
                int offset = SwordUtil.decodeLittleEndian32(buffer, 0);
                int size = SwordUtil.decodeLittleEndian32(buffer, 4);
                byte[] data = SwordUtil.readRAF(this.datRaf, offset, size);
                int keyend = SwordUtil.findByte(data, (byte)10);
                if (keyend == -1) {
                    DataPolice.report("Failed to find keyname. offset=" + offset + " data='" + new String(data) + "'");
                } else {
                    byte[] keydata = new byte[keyend];
                    System.arraycopy(data, 0, keydata, 0, keyend);
                    String keytitle = SwordUtil.decode(this.keys, keydata, charset).trim();
                    if (keytitle.endsWith("\\")) {
                        keytitle = keytitle.substring(0, keytitle.length() - 1);
                    }
                    if (isDailyDevotional) {
                        String[] parts = StringUtil.splitAll((String)keytitle, (char)'.');
                        greg.set(2, Integer.parseInt(parts[0]) - 1);
                        greg.set(5, Integer.parseInt(parts[1]));
                        keytitle = nameDF.format(greg.getTime());
                    }
                    IndexKey key = new IndexKey(keytitle, offset, size, this.keys);
                    this.keys.addAll(key);
                }
            }
            catch (IOException ex) {
                log.error("Ignoring entry", (Throwable)ex);
            }
            catch (NumberFormatException e) {
                log.error("Ignoring entry", (Throwable)e);
            }
            ++entry;
        }
        return this.keys;
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        String charset = this.getBookMetaData().getBookCharset();
        if (!(key instanceof IndexKey)) {
            throw new BookException((MsgBase)Msg.BAD_KEY, new Object[]{ClassUtil.getShortClassName(key.getClass()), key.getName()});
        }
        IndexKey ikey = (IndexKey)key;
        try {
            byte[] data = SwordUtil.readRAF(this.datRaf, ikey.getOffset(), ikey.getSize());
            int keyend = SwordUtil.findByte(data, (byte)10);
            if (keyend == -1) {
                throw new BookException(Msg.READ_FAIL);
            }
            int remainder = data.length - (keyend + 1);
            byte[] temp = new byte[remainder];
            System.arraycopy(data, keyend + 1, temp, 0, remainder);
            String linkCheck = new String(temp, 0, 5, charset);
            if ("@LINK".equals(linkCheck)) {
                keyend = SwordUtil.findByte(temp, (byte)10);
                String linkKey = new String(temp, 6, temp.length - (keyend + 1), charset).trim();
                ikey = (IndexKey)this.keys.get(this.keys.indexOf(new IndexKey(linkKey)));
                return this.getRawText(ikey);
            }
            int blockNum = SwordUtil.decodeLittleEndian32(temp, 0);
            int entry = SwordUtil.decodeLittleEndian32(temp, 4);
            byte[] uncompressed = null;
            if (blockNum == this.lastBlockNum) {
                uncompressed = this.lastUncompressed;
            } else {
                temp = SwordUtil.readRAF(this.zdxRaf, blockNum * 8, 8);
                if (temp == null || temp.length == 0) {
                    return "";
                }
                int blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
                int blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
                temp = SwordUtil.readRAF(this.zdtRaf, blockStart, blockSize);
                this.decipher(temp);
                uncompressed = SwordUtil.uncompress(temp);
                this.lastBlockNum = blockNum;
                this.lastUncompressed = uncompressed;
            }
            int entryCount = SwordUtil.decodeLittleEndian32(uncompressed, 0);
            if (entry >= entryCount) {
                return "";
            }
            int entryOffset = 4 + 8 * entry;
            int entryStart = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset);
            int entrySize = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset + 4);
            byte[] entryBytes = new byte[entrySize];
            System.arraycopy(uncompressed, entryStart, entryBytes, 0, entrySize);
            return SwordUtil.decode(key, entryBytes, charset).trim();
        }
        catch (IOException e) {
            throw new BookException((MsgBase)Msg.READ_FAIL, e);
        }
    }

    public boolean isSupported() {
        return true;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }
}

