/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Map;
import javax.swing.event.EventListenerList;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.basic.Msg;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.IndexStatusEvent;
import org.crosswire.jsword.index.IndexStatusListener;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.index.search.SearchRequest;
import org.crosswire.jsword.index.search.Searcher;
import org.crosswire.jsword.index.search.SearcherFactory;
import org.crosswire.jsword.passage.Key;
import org.jdom.Document;

public abstract class AbstractBook
implements Book {
    private Searcher searcher;
    private BookMetaData bmd;
    private EventListenerList listeners;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public AbstractBook(BookMetaData bmd) {
        this.setBookMetaData(bmd);
    }

    public final BookMetaData getBookMetaData() {
        return this.bmd;
    }

    public final void setBookMetaData(BookMetaData bmd) {
        this.bmd = bmd;
    }

    public void activate(Lock lock) {
    }

    public void deactivate(Lock lock) {
    }

    public Key find(String request) throws BookException {
        return this.find(new DefaultSearchRequest(request));
    }

    public Key find(SearchRequest request) throws BookException {
        if (this.searcher == null) {
            try {
                this.searcher = SearcherFactory.createSearcher(this);
            }
            catch (InstantiationException ex) {
                throw new BookException((MsgBase)Msg.INDEX_FAIL, ex);
            }
        }
        return this.searcher.search(request);
    }

    public Book getBook() {
        return this;
    }

    public BookDriver getDriver() {
        return this.bmd == null ? null : this.bmd.getDriver();
    }

    public String getDriverName() {
        return this.bmd == null ? null : this.bmd.getDriverName();
    }

    public String getFullName() {
        return this.bmd.getFullName();
    }

    public IndexStatus getIndexStatus() {
        return this.bmd.getIndexStatus();
    }

    public void setIndexStatus(IndexStatus newStatus) {
        IndexStatus oldStatus = this.bmd.getIndexStatus();
        this.bmd.setIndexStatus(newStatus);
        this.firePropertyChange(oldStatus, newStatus);
    }

    public String getInitials() {
        return this.bmd.getInitials();
    }

    public String getLanguage() {
        return this.bmd.getLanguage();
    }

    public String getName() {
        return this.bmd.getName();
    }

    public String getOsisID() {
        return this.bmd.getOsisID();
    }

    public Map getProperties() {
        return this.bmd.getProperties();
    }

    public String getProperty(String key) {
        return this.bmd.getProperty(key);
    }

    public void putProperty(String key, String value) {
        this.bmd.putProperty(key, value);
    }

    public BookCategory getBookCategory() {
        return this.bmd.getBookCategory();
    }

    public boolean isLeftToRight() {
        return this.bmd.isLeftToRight();
    }

    public boolean isSupported() {
        return this.bmd.isSupported();
    }

    public boolean isEnciphered() {
        return this.bmd.isEnciphered();
    }

    public boolean isLocked() {
        return this.bmd.isLocked();
    }

    public boolean unlock(String unlockKey) {
        return this.bmd.unlock(unlockKey);
    }

    public String getUnlockKey() {
        return this.bmd.getUnlockKey();
    }

    public boolean isQuestionable() {
        return this.bmd.isQuestionable();
    }

    public boolean hasFeature(FeatureType feature) {
        return this.bmd.hasFeature(feature);
    }

    public void addIndexStatusListener(IndexStatusListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(IndexStatusListener.class, listener);
    }

    public void removeIndexStatusListener(IndexStatusListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(IndexStatusListener.class, listener);
    }

    protected void firePropertyChange(IndexStatus oldStatus, IndexStatus newStatus) {
        if (this.listeners != null) {
            if (oldStatus != null && newStatus != null && oldStatus.equals(newStatus)) {
                return;
            }
            Object[] listenerList = this.listeners.getListenerList();
            for (int i = 0; i <= listenerList.length - 2; i += 2) {
                if (listenerList[i] != (class$java$beans$PropertyChangeListener == null ? AbstractBook.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                IndexStatusEvent ev = new IndexStatusEvent(this, newStatus);
                IndexStatusListener li = (IndexStatusListener)listenerList[i + 1];
                li.statusChanged(ev);
            }
        }
    }

    public Document toOSIS() {
        return this.bmd.toOSIS();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Book that = (Book)obj;
        return this.bmd.equals(that.getBookMetaData());
    }

    public int hashCode() {
        return this.bmd.hashCode();
    }

    public int compareTo(Object obj) {
        return this.bmd.compareTo(((Book)obj).getBookMetaData());
    }

    public String toString() {
        return this.bmd.toString();
    }
}

