/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Serializable;
import org.crosswire.jsword.book.sword.Msg;

public abstract class BlockType
implements Serializable {
    public static final BlockType BLOCK_BOOK = new BlockType("BOOK"){
        private static final long serialVersionUID = 3257569486067807287L;

        public char getIndicator() {
            return 'b';
        }
    };
    public static final BlockType BLOCK_CHAPTER = new BlockType("CHAPTER"){
        private static final long serialVersionUID = 3762533416838968372L;

        public char getIndicator() {
            return 'c';
        }
    };
    public static final BlockType BLOCK_VERSE = new BlockType("VERSE"){
        private static final long serialVersionUID = 3257572793192362551L;

        public char getIndicator() {
            return 'v';
        }
    };
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final BlockType[] VALUES;

    public BlockType(String name) {
        this.name = name;
    }

    abstract char getIndicator();

    public static BlockType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BlockType obj = VALUES[i];
            if (!obj.name.equalsIgnoreCase(name)) continue;
            return obj;
        }
        throw new ClassCastException(Msg.UNDEFINED_DATATYPE.toString(name));
    }

    public static BlockType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new BlockType[]{BLOCK_BOOK, BLOCK_CHAPTER, BLOCK_VERSE};
    }
}

