/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.util;

import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import javax.xml.transform.TransformerException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.util.URLFilter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;

public class ConfigurableSwingConverter
implements Converter {
    private static String font = "Serif,0,14";
    private static String style = "simple.xsl";

    public String[] getStyles() {
        try {
            String search = "xsl/cswing/index.txt";
            URL index = ResourceUtil.getResource((String)search);
            return NetUtil.listByIndexFile((URL)index, (URLFilter)new XSLTFilter());
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    public SAXEventProvider convert(SAXEventProvider xmlsep) throws TransformerException {
        try {
            String path = "xsl/cswing/" + style;
            URL xslurl = ResourceUtil.getResource((String)path);
            TransformingSAXEventProvider tsep = new TransformingSAXEventProvider(xslurl, xmlsep);
            tsep.setParameter("font", (Object)font);
            return tsep;
        }
        catch (MissingResourceException ex) {
            throw new TransformerException(ex);
        }
    }

    public static String getFont() {
        return font;
    }

    public static Font toFont() {
        String[] fontSpec = StringUtil.split((String)font, (String)",");
        int fontStyle = Integer.parseInt(fontSpec[1]);
        int fontSize = Integer.parseInt(fontSpec[2]);
        Font newFont = new Font(fontSpec[0], fontStyle, fontSize);
        return newFont;
    }

    public static void setFont(String font) {
        ConfigurableSwingConverter.font = font;
    }

    public static String getResourceName() {
        return style;
    }

    public static void setResourceName(String style) {
        ConfigurableSwingConverter.style = style;
    }

    static final class XSLTFilter
    implements URLFilter {
        XSLTFilter() {
        }

        public boolean accept(String name) {
            return name.endsWith(".xsl");
        }
    }
}

