/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;

public final class Project {
    public static final String DIR_NETCACHE = "netcache";
    public static final String DIR_PROJECT = ".jsword";
    private URL home;
    private static final Logger log;
    private static Project instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Project instance() {
        return instance;
    }

    private Project() {
        block4: {
            try {
                String path = System.getProperty("user.home") + File.separator + DIR_PROJECT;
                this.home = new URL("file", null, path);
                CWClassLoader.setHome((URL)this.home);
            }
            catch (MalformedURLException ex) {
                log.fatal("Failed to create home directory URL", (Throwable)ex);
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex);
            }
        }
        try {
            URL urlcache = this.getTempScratchSpace(DIR_NETCACHE, true);
            File filecache = new File(urlcache.getFile());
            NetUtil.setURLCacheDir((File)filecache);
        }
        catch (IOException ex) {
            log.warn("Failed to get directory for NetUtil.setURLCacheDir()", (Throwable)ex);
        }
    }

    public URL getWritablePropertiesURL(String subject) {
        return NetUtil.lengthenURL((URL)this.home, (String)(subject + ".properties"));
    }

    public URL getTempScratchSpace(String subject, boolean create) throws IOException {
        URL temp = NetUtil.lengthenURL((URL)this.home, (String)subject);
        if (create && !NetUtil.isDirectory((URL)temp)) {
            NetUtil.makeDirectory((URL)temp);
        }
        return temp;
    }

    static {
        $assertionsDisabled = !Project.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)Project.class);
        instance = new Project();
    }
}

