/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.crosswire.bibledesktop.book.install.Msg;
import org.crosswire.bibledesktop.book.install.SiteEditor;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;

public class SwordSiteEditor
extends JPanel
implements SiteEditor {
    private AbstractSwordInstaller installer;
    private JTextField host;
    private JTextField directory;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private static final long serialVersionUID = 3834589894202175795L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize() {
        this.host = new JTextField();
        JLabel hostLabel = this.getLabelForText(Msg.HOST, this.host);
        this.directory = new JTextField();
        JLabel directoryLabel = this.getLabelForText(Msg.DIRECTORY, this.directory);
        this.proxyHost = new JTextField();
        JLabel proxyHostLabel = this.getLabelForText(Msg.PROXY_HOST, this.proxyHost);
        this.proxyPort = new JTextField();
        JLabel proxyPortLabel = this.getLabelForText(Msg.PROXY_PORT, this.proxyPort);
        this.setLayout(new GridBagLayout());
        this.add((Component)hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 2, 2), 0, 0));
        this.add((Component)this.host, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        this.add((Component)directoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 2, 2), 0, 0));
        this.add((Component)this.directory, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        this.add((Component)proxyHostLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 2, 2), 0, 0));
        this.add((Component)this.proxyHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        this.add((Component)proxyPortLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 2, 2), 0, 0));
        this.add((Component)this.proxyPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        this.reset();
    }

    public void save() {
        this.installer.setHost(this.host.getText());
        this.installer.setDirectory(this.directory.getText());
        this.installer.setProxyHost(this.proxyHost.getText());
        Integer pport = null;
        try {
            pport = new Integer(this.proxyPort.getText());
        }
        catch (NumberFormatException e) {
            pport = null;
        }
        this.installer.setProxyPort(pport);
    }

    public void reset() {
        if (this.installer == null) {
            return;
        }
        this.host.setText(this.installer.getHost());
        this.directory.setText(this.installer.getDirectory());
        this.proxyHost.setText(this.installer.getProxyHost());
        Integer port = this.installer.getProxyPort();
        this.proxyPort.setText(port == null ? null : port.toString());
    }

    public void setEditable(boolean editable) {
        if (this.host != null) {
            this.host.setEditable(editable);
        }
        if (this.directory != null) {
            this.directory.setEditable(editable);
        }
        if (this.proxyHost != null) {
            this.proxyHost.setEditable(editable);
        }
        if (this.proxyPort != null) {
            this.proxyPort.setEditable(editable);
        }
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public void setInstaller(Installer newInstaller) {
        if (!$assertionsDisabled && newInstaller != null && !(newInstaller instanceof AbstractSwordInstaller)) {
            throw new AssertionError();
        }
        AbstractSwordInstaller old = this.installer;
        this.installer = (AbstractSwordInstaller)newInstaller;
        if (newInstaller == null) {
            this.removeAll();
        } else if (!newInstaller.equals(old)) {
            this.removeAll();
            this.initialize();
        }
    }

    private JLabel getLabelForText(Msg title, JTextField field) {
        JLabel label = new JLabel();
        label.setText(title.toString());
        label.setLabelFor(field);
        return label;
    }

    static {
        $assertionsDisabled = !SwordSiteEditor.class.desiredAssertionStatus();
    }
}

