/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.awt.ComponentOrientation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.jdom.Content;
import org.jdom.Element;

public class ConfigEntryTable {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_LATIN1 = "WINDOWS-1252";
    public static final ConfigEntryType[] REQUIRED = new ConfigEntryType[]{ConfigEntryType.INITIALS, ConfigEntryType.DESCRIPTION, ConfigEntryType.CATEGORY, ConfigEntryType.DATA_PATH, ConfigEntryType.MOD_DRV};
    public static final ConfigEntryType[] BASIC_INFO = new ConfigEntryType[]{ConfigEntryType.INITIALS, ConfigEntryType.DESCRIPTION, ConfigEntryType.CATEGORY, ConfigEntryType.LCSH, ConfigEntryType.VERSION, ConfigEntryType.SWORD_VERSION_DATE, ConfigEntryType.HISTORY};
    public static final ConfigEntryType[] LANG_INFO = new ConfigEntryType[]{ConfigEntryType.LANGUAGE, ConfigEntryType.LANG, ConfigEntryType.LANGUAGE_FROM, ConfigEntryType.GLOSSARY_FROM, ConfigEntryType.LANGUAGE_TO, ConfigEntryType.GLOSSARY_TO};
    public static final ConfigEntryType[] COPYRIGHT_INFO = new ConfigEntryType[]{ConfigEntryType.ABOUT, ConfigEntryType.SHORT_PROMO, ConfigEntryType.DISTRIBUTION_LICENSE, ConfigEntryType.DISTRIBUTION_NOTES, ConfigEntryType.DISTRIBUTION_SOURCE, ConfigEntryType.SHORT_COPYRIGHT, ConfigEntryType.COPYRIGHT, ConfigEntryType.COPYRIGHT_DATE, ConfigEntryType.COPYRIGHT_HOLDER, ConfigEntryType.COPYRIGHT_CONTACT_NAME, ConfigEntryType.COPYRIGHT_CONTACT_ADDRESS, ConfigEntryType.COPYRIGHT_CONTACT_EMAIL, ConfigEntryType.COPYRIGHT_NOTES, ConfigEntryType.TEXT_SOURCE};
    public static final ConfigEntryType[] FEATURE_INFO = new ConfigEntryType[]{ConfigEntryType.FEATURE, ConfigEntryType.GLOBAL_OPTION_FILTER, ConfigEntryType.FONT};
    public static final ConfigEntryType[] SYSTEM_INFO = new ConfigEntryType[]{ConfigEntryType.DATA_PATH, ConfigEntryType.MOD_DRV, ConfigEntryType.SOURCE_TYPE, ConfigEntryType.BLOCK_TYPE, ConfigEntryType.COMPRESS_TYPE, ConfigEntryType.ENCODING, ConfigEntryType.MINIMUM_VERSION, ConfigEntryType.DIRECTION};
    public static final ConfigEntryType[] HIDDEN = new ConfigEntryType[]{ConfigEntryType.CIPHER_KEY};
    private static final Logger log = Logger.getLogger((Class)ConfigEntryTable.class);
    private String internal;
    private Map table;
    private BookType bookType;
    private boolean supported;
    private boolean questionable;
    private String readahead;
    private File configFile;

    public ConfigEntryTable(File file, String bookName) throws IOException {
        this.configFile = file;
        this.internal = bookName;
        this.supported = true;
        this.table = new HashMap();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_LATIN1));
        this.loadInitials(in);
        this.loadContents(in);
        in.close();
        if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_UTF8)) {
            this.supported = true;
            this.bookType = null;
            this.questionable = false;
            this.readahead = null;
            this.table.clear();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_UTF8));
            this.loadInitials(in);
            this.loadContents(in);
            in.close();
        }
        this.adjustLanguage();
        this.adjustBookType();
        this.adjustName();
        this.validate();
    }

    public ConfigEntryTable(byte[] buffer, String bookName) throws IOException {
        this.internal = bookName;
        this.supported = true;
        this.table = new HashMap();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer), ENCODING_LATIN1));
        this.loadInitials(in);
        this.loadContents(in);
        in.close();
        if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_UTF8)) {
            this.supported = true;
            this.bookType = null;
            this.questionable = false;
            this.readahead = null;
            this.table.clear();
            in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer), ENCODING_UTF8));
            this.loadInitials(in);
            this.loadContents(in);
            in.close();
        }
        this.adjustLanguage();
        this.adjustBookType();
        this.adjustName();
        this.validate();
    }

    public boolean isQuestionable() {
        return this.questionable;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean isEnciphered() {
        String cipher = (String)this.getValue(ConfigEntryType.CIPHER_KEY);
        return cipher != null;
    }

    public boolean isLocked() {
        String cipher = (String)this.getValue(ConfigEntryType.CIPHER_KEY);
        return cipher != null && cipher.length() == 0;
    }

    public boolean unlock(String unlockKey) {
        if (unlockKey != null) {
            unlockKey = unlockKey.trim();
        }
        this.add(ConfigEntryType.CIPHER_KEY, unlockKey);
        if (this.configFile != null) {
            try {
                this.save();
            }
            catch (IOException e) {
                Reporter.informUser((Object)this, (MsgBase)Msg.UNLOCK_FAILED, (Object)e);
            }
        }
        return true;
    }

    public String getUnlockKey() {
        return (String)this.getValue(ConfigEntryType.CIPHER_KEY);
    }

    public Set getKeys() {
        return this.table.keySet();
    }

    public BookType getBookType() {
        return this.bookType;
    }

    public Object getValue(ConfigEntryType type) {
        ConfigEntry ce = (ConfigEntry)this.table.get(type);
        if (ce != null) {
            return ce.getValue();
        }
        return type.getDefault();
    }

    public boolean match(ConfigEntryType type, Object search) {
        ConfigEntry ce = (ConfigEntry)this.table.get(type);
        return ce != null && ce.match(search);
    }

    public Element toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element ele = factory.createTable();
        this.toOSIS(factory, ele, "BasicInfo", BASIC_INFO);
        this.toOSIS(factory, ele, "LangInfo", LANG_INFO);
        this.toOSIS(factory, ele, "LicenseInfo", COPYRIGHT_INFO);
        this.toOSIS(factory, ele, "FeatureInfo", FEATURE_INFO);
        this.toOSIS(factory, ele, "SysInfo", SYSTEM_INFO);
        return ele;
    }

    public String toConf() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.getValue(ConfigEntryType.INITIALS));
        buf.append(']');
        buf.append('\n');
        this.toConf(buf, BASIC_INFO);
        this.toConf(buf, SYSTEM_INFO);
        this.toConf(buf, HIDDEN);
        this.toConf(buf, FEATURE_INFO);
        this.toConf(buf, LANG_INFO);
        this.toConf(buf, COPYRIGHT_INFO);
        return buf.toString();
    }

    public void save() throws IOException {
        if (this.configFile != null) {
            String encoding = ENCODING_LATIN1;
            if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_UTF8)) {
                encoding = ENCODING_UTF8;
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), encoding);
            writer.write(this.toConf());
            ((Writer)writer).close();
        }
    }

    private void loadContents(BufferedReader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            buf.setLength(0);
            String line = this.advance(in);
            if (line == null) break;
            if (line.length() == 0) continue;
            int eqpos = line.indexOf("=");
            if (eqpos == -1) {
                log.warn("Expected to see '=' in " + this.internal + ": " + line);
                continue;
            }
            String key = line.substring(0, eqpos).trim();
            String value = line.substring(eqpos + 1).trim();
            if (value.length() == 0 && !ConfigEntryType.CIPHER_KEY.getName().equals(key)) {
                log.warn("Ignoring empty entry in " + this.internal + ": " + line);
                continue;
            }
            ConfigEntry configEntry = new ConfigEntry(this.internal, key);
            ConfigEntry e = (ConfigEntry)this.table.get(configEntry.getType());
            if (e == null) {
                ConfigEntryType type = configEntry.getType();
                if (type == null) {
                    log.warn("Ignoring unexpected entry in " + this.internal + " of " + configEntry.getName());
                } else if (type.isSynthetic()) {
                    log.warn("Ignoring unexpected entry in " + this.internal + " of " + configEntry.getName());
                } else {
                    this.table.put(configEntry.getType(), configEntry);
                }
            } else {
                configEntry = e;
            }
            buf.append(value);
            this.getContinuation(configEntry, in, buf);
            value = buf.toString();
            if (ConfigEntryType.HISTORY.equals(configEntry.getType())) {
                int pos = key.indexOf(95);
                value = key.substring(pos + 1) + ' ' + value;
            }
            configEntry.addValue(value);
        }
    }

    private void loadInitials(BufferedReader in) throws IOException {
        String line;
        String initials = null;
        while ((line = this.advance(in)) != null) {
            if (line.charAt(0) != '[' || line.charAt(line.length() - 1) != ']') continue;
            initials = line.substring(1, line.length() - 1);
            break;
        }
        if (initials == null) {
            log.error("Malformed conf file for " + this.internal + " no initials found. Using internal of " + this.internal);
            initials = this.internal;
        }
        this.add(ConfigEntryType.INITIALS, initials);
    }

    private void getContinuation(ConfigEntry configEntry, BufferedReader bin, StringBuffer buf) throws IOException {
        String line = this.advance(bin);
        while (line != null) {
            boolean continuation_expected;
            int length = buf.length();
            boolean bl = continuation_expected = length > 0 && buf.charAt(length - 1) == '\\';
            if (continuation_expected) {
                buf.deleteCharAt(length - 1);
            }
            if (this.isKeyLine(line)) {
                if (continuation_expected) {
                    log.warn("Continuation followed by key for " + configEntry.getName() + " in " + this.internal + ": " + line);
                }
                this.backup(line);
                break;
            }
            if (!continuation_expected) {
                log.warn("Line without previous continuation for " + configEntry.getName() + " in " + this.internal + ": " + line);
            }
            if (!configEntry.allowsContinuation()) {
                log.warn("Ignoring unexpected additional line for " + configEntry.getName() + " in " + this.internal + ": " + line);
            } else {
                if (continuation_expected) {
                    buf.append('\n');
                }
                buf.append(line);
            }
            line = this.advance(bin);
        }
    }

    private String advance(BufferedReader bin) throws IOException {
        if (this.readahead != null) {
            String line = this.readahead;
            this.readahead = null;
            return line;
        }
        String trimmed = null;
        String line = bin.readLine();
        while (line != null) {
            trimmed = line.trim();
            int length = trimmed.length();
            if (length != 0 && trimmed.charAt(0) != '#') {
                return trimmed;
            }
            line = bin.readLine();
        }
        return null;
    }

    private void backup(String oops) {
        if (oops.length() > 0) {
            this.readahead = oops;
        } else {
            log.error("Backup an empty string for " + this.internal);
        }
    }

    private boolean isKeyLine(String line) {
        return line.indexOf(61) != -1;
    }

    private void add(ConfigEntryType type, String aValue) {
        this.table.put(type, new ConfigEntry(this.internal, type, aValue));
    }

    private void adjustLanguage() {
        String dir = (String)this.getValue(ConfigEntryType.DIRECTION);
        String newDir = dir == null ? (String)ConfigEntryType.DIRECTION.getDefault() : dir;
        String langEntry = (String)this.getValue(ConfigEntryType.LANG);
        String lang = AbstractBookMetaData.getLanguage(this.internal, langEntry);
        this.add(ConfigEntryType.LANGUAGE, lang);
        boolean leftToRight = true;
        if (langEntry != null) {
            leftToRight = ComponentOrientation.getOrientation(new Locale(langEntry)).isLeftToRight();
        }
        String langFromEntry = (String)this.getValue(ConfigEntryType.GLOSSARY_FROM);
        String langToEntry = (String)this.getValue(ConfigEntryType.GLOSSARY_TO);
        if (langFromEntry != null || langToEntry != null) {
            String langFrom = AbstractBookMetaData.getLanguage(this.internal, langFromEntry);
            this.add(ConfigEntryType.LANGUAGE_FROM, langFrom);
            String langTo = AbstractBookMetaData.getLanguage(this.internal, langToEntry);
            this.add(ConfigEntryType.LANGUAGE_TO, langTo);
            boolean fromLeftToRight = true;
            boolean toLeftToRight = true;
            if (langFromEntry == null) {
                log.warn("Missing data for " + this.internal + ". Assuming " + ConfigEntryType.GLOSSARY_FROM.getName() + "=" + "en");
            } else {
                fromLeftToRight = ComponentOrientation.getOrientation(new Locale(langFromEntry)).isLeftToRight();
            }
            if (langToEntry == null) {
                log.warn("Missing data for " + this.internal + ". Assuming " + ConfigEntryType.GLOSSARY_TO.getName() + "=" + "en");
            } else {
                toLeftToRight = ComponentOrientation.getOrientation(new Locale(langToEntry)).isLeftToRight();
            }
            if (!langFrom.equals(lang) && !langTo.equals(lang)) {
                log.error("Data error in " + this.internal + ". Neither " + ConfigEntryType.GLOSSARY_FROM.getName() + " or " + ConfigEntryType.GLOSSARY_FROM.getName() + " match " + ConfigEntryType.LANG.getName());
            }
            newDir = fromLeftToRight != toLeftToRight ? "bidi" : (fromLeftToRight ? "LtoR" : "RtoL");
        } else {
            newDir = leftToRight ? "LtoR" : "RtoL";
        }
        if (newDir.equals("LtoR")) {
            if (dir != null) {
                if (!newDir.equals(dir)) {
                    log.warn("Fixing data for " + this.internal + ". Changing " + ConfigEntryType.DIRECTION.getName() + "=" + dir + " to " + newDir);
                }
                this.table.remove(ConfigEntryType.DIRECTION);
            }
        } else if (!newDir.equals(dir)) {
            if (dir == null) {
                log.warn("Fixing data for " + this.internal + ". Adding " + ConfigEntryType.DIRECTION.getName() + "=" + newDir);
            } else {
                log.warn("Fixing data for " + this.internal + ". Changing " + ConfigEntryType.DIRECTION.getName() + "=" + dir + " to " + newDir);
            }
            this.add(ConfigEntryType.DIRECTION, newDir);
        }
    }

    private void adjustBookType() {
        BookCategory focusedCategory = BookCategory.fromString(this.getValue(ConfigEntryType.CATEGORY).toString());
        this.questionable = focusedCategory == BookCategory.QUESTIONABLE;
        String modTypeName = (String)this.getValue(ConfigEntryType.MOD_DRV);
        if (modTypeName == null) {
            log.error("Book not supported: malformed conf file for " + this.internal + " no " + ConfigEntryType.MOD_DRV.getName() + " found");
            this.supported = false;
            return;
        }
        this.bookType = BookType.fromString(modTypeName);
        if (this.getBookType() == null) {
            log.error("Book not supported: malformed conf file for " + this.internal + " no book type found");
            this.supported = false;
            return;
        }
        BookCategory basicCategory = this.getBookType().getBookCategory();
        if (basicCategory == null) {
            this.supported = false;
            return;
        }
        if (focusedCategory == BookCategory.OTHER || focusedCategory == BookCategory.QUESTIONABLE) {
            focusedCategory = this.getBookType().getBookCategory();
        }
        this.add(ConfigEntryType.CATEGORY, focusedCategory.toString());
    }

    private void adjustName() {
        if (this.table.get(ConfigEntryType.DESCRIPTION) == null) {
            log.error("Malformed conf file for " + this.internal + " no " + ConfigEntryType.DESCRIPTION.getName() + " found. Using internal of " + this.internal);
            this.add(ConfigEntryType.DESCRIPTION, this.internal);
        }
    }

    private void validate() {
    }

    private void toOSIS(OSISUtil.OSISFactory factory, Element ele, String aTitle, ConfigEntryType[] category) {
        Element title = null;
        for (int i = 0; i < category.length; ++i) {
            ConfigEntry entry = (ConfigEntry)this.table.get(category[i]);
            Element configElement = null;
            if (entry != null) {
                configElement = entry.toOSIS();
            }
            if (title == null && configElement != null) {
                title = factory.createHeader();
                title.addContent(aTitle);
                ele.addContent((Content)title);
            }
            if (configElement == null) continue;
            ele.addContent((Content)configElement);
        }
    }

    private void toConf(StringBuffer buf, ConfigEntryType[] category) {
        for (int i = 0; i < category.length; ++i) {
            String text;
            ConfigEntry entry = (ConfigEntry)this.table.get(category[i]);
            if (entry == null || entry.getType().isSynthetic() || (text = entry.toConf()) == null || text.length() <= 0) continue;
            buf.append(entry.toConf());
        }
    }
}

