/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.crypt.Sapphire;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.Key;

public abstract class AbstractBackend
implements Activatable {
    private SwordBookMetaData bmd;
    private File rootPath;

    public AbstractBackend(SwordBookMetaData sbmd, File location) {
        this.bmd = sbmd;
        this.rootPath = location;
    }

    public File getRootPath() {
        return this.rootPath;
    }

    public SwordBookMetaData getBookMetaData() {
        return this.bmd;
    }

    public void decipher(byte[] data) {
        String cipherKeyString = this.getBookMetaData().getProperty(ConfigEntryType.CIPHER_KEY);
        if (cipherKeyString != null) {
            Sapphire cipherEngine = new Sapphire(cipherKeyString.getBytes());
            for (int i = 0; i < data.length; ++i) {
                data[i] = cipherEngine.cipher(data[i]);
            }
        }
    }

    public abstract Key readIndex();

    public abstract String getRawText(Key var1) throws BookException;

    public abstract boolean isSupported();
}

