/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.text.MessageFormat;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.MsgBase;

public class LucidException
extends Exception {
    private static final Logger log = Logger.getLogger(LucidException.class);
    private static final long serialVersionUID = 3257846580311963191L;
    private final boolean deprecated;
    protected final Object[] params;

    public LucidException(MsgBase msg) {
        this(msg, null, null);
    }

    public LucidException(MsgBase msg, Throwable cause) {
        this(msg, cause, null);
    }

    public LucidException(MsgBase msg, Object[] params) {
        this(msg, null, params);
    }

    public LucidException(MsgBase msg, Throwable cause, Object[] params) {
        super(msg.toString(), cause);
        this.deprecated = false;
        this.params = params != null ? (Object[])params.clone() : null;
    }

    public String getMessage() {
        String out = super.getMessage();
        if (this.deprecated || this.params == null) {
            return out;
        }
        try {
            return MessageFormat.format(out, this.params);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Format fail for '" + out + '\'', ex);
            return "Error formatting message '" + out + '\'';
        }
    }

    public String getDetailedMessage() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return this.getMessage();
        }
        if (cause instanceof LucidException) {
            LucidException lex = (LucidException)cause;
            return this.getMessage() + Msg.REASON + lex.getDetailedMessage();
        }
        return this.getMessage() + Msg.REASON + cause.getMessage();
    }
}

