/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;

public class TarHeader
implements Cloneable {
    public static final int NAMELEN = 100;
    public static final int NAMEOFFSET = 0;
    public static final int PREFIXLEN = 155;
    public static final int PREFIXOFFSET = 345;
    public static final int MODELEN = 8;
    public static final int UIDLEN = 8;
    public static final int GIDLEN = 8;
    public static final int CHKSUMLEN = 8;
    public static final int SIZELEN = 12;
    public static final int MAGICLEN = 8;
    public static final int MODTIMELEN = 12;
    public static final int UNAMELEN = 32;
    public static final int GNAMELEN = 32;
    public static final int DEVLEN = 8;
    public static final byte LF_OLDNORM = 0;
    public static final byte LF_NORMAL = 48;
    public static final byte LF_LINK = 49;
    public static final byte LF_SYMLINK = 50;
    public static final byte LF_CHR = 51;
    public static final byte LF_BLK = 52;
    public static final byte LF_DIR = 53;
    public static final byte LF_FIFO = 54;
    public static final byte LF_CONTIG = 55;
    public static final String TMAGIC = "ustar";
    public static final String GNU_TMAGIC = "ustar  ";
    public StringBuffer name;
    public int mode;
    public int userId;
    public int groupId;
    public long size;
    public long modTime;
    public int checkSum;
    public byte linkFlag;
    public StringBuffer linkName;
    public StringBuffer magic = new StringBuffer("ustar");
    public StringBuffer userName;
    public StringBuffer groupName;
    public int devMajor;
    public int devMinor;

    public TarHeader() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(user);
        this.groupName = new StringBuffer("");
    }

    public Object clone() {
        TarHeader hdr = null;
        try {
            hdr = (TarHeader)super.clone();
            hdr.name = this.name == null ? null : new StringBuffer(this.name.toString());
            hdr.mode = this.mode;
            hdr.userId = this.userId;
            hdr.groupId = this.groupId;
            hdr.size = this.size;
            hdr.modTime = this.modTime;
            hdr.checkSum = this.checkSum;
            hdr.linkFlag = this.linkFlag;
            hdr.linkName = this.linkName == null ? null : new StringBuffer(this.linkName.toString());
            hdr.magic = this.magic == null ? null : new StringBuffer(this.magic.toString());
            hdr.userName = this.userName == null ? null : new StringBuffer(this.userName.toString());
            hdr.groupName = this.groupName == null ? null : new StringBuffer(this.groupName.toString());
            hdr.devMajor = this.devMajor;
            hdr.devMinor = this.devMinor;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace(System.err);
        }
        return hdr;
    }

    public String getName() {
        return this.name.toString();
    }

    public static long parseOctal(byte[] header, int offset, int length) {
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            if (header[i] == 32 || header[i] == 48) {
                if (stillPadding) continue;
                if (header[i] == 32) break;
            }
            stillPadding = false;
            result = (result << 3) + (long)(header[i] - 48);
        }
        return result;
    }

    public static StringBuffer parseFileName(byte[] header) {
        int i;
        StringBuffer result = new StringBuffer(256);
        if (header[345] != 0) {
            for (i = 345; i < 500 && header[i] != 0; ++i) {
                result.append((char)header[i]);
            }
            result.append("/");
        }
        for (i = 0; i < 100 && header[i] != 0; ++i) {
            result.append((char)header[i]);
        }
        return result;
    }

    public static StringBuffer parseName(byte[] header, int offset, int length) {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            result.append((char)header[i]);
        }
        return result;
    }

    public static int getFileNameBytes(String newName, byte[] outbuf) throws InvalidHeaderException {
        if (newName.length() > 100) {
            int index = newName.indexOf("/", newName.length() - 100);
            if (index == -1) {
                throw new InvalidHeaderException("file name is greater than 100 characters, " + newName);
            }
            String name = newName.substring(index + 1);
            String prefix = newName.substring(0, index);
            if (prefix.length() > 155) {
                throw new InvalidHeaderException("file prefix is greater than 155 characters");
            }
            TarHeader.getNameBytes(new StringBuffer(name), outbuf, 0, 100);
            TarHeader.getNameBytes(new StringBuffer(prefix), outbuf, 345, 155);
        } else {
            TarHeader.getNameBytes(new StringBuffer(newName), outbuf, 0, 100);
        }
        return 100;
    }

    public static int getNameBytes(StringBuffer name, byte[] buf, int offset, int length) {
        int i;
        for (i = 0; i < length && i < name.length(); ++i) {
            buf[offset + i] = (byte)name.charAt(i);
        }
        while (i < length) {
            buf[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    public static int getOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 1;
        buf[offset + idx] = 0;
        buf[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buf[offset + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buf[offset + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buf[offset + idx] = 32;
            --idx;
        }
        return offset + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] temp = new byte[length + 1];
        TarHeader.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset, length);
        return offset + length;
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        TarHeader.getOctalBytes(value, buf, offset, length);
        buf[offset + length - 1] = 32;
        buf[offset + length - 2] = 0;
        return offset + length;
    }
}

