/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.Serializable;

public class XMLFeature
implements Serializable,
Comparable {
    public static final XMLFeature NAMESPACES;
    public static final XMLFeature NAMESPACE_PREFIX;
    public static final XMLFeature VALIDATION;
    public static final XMLFeature SCHEMA_VALIDATION;
    public static final XMLFeature SCHEMA_FULL_CHECKING;
    public static final XMLFeature VALIDATE_ANNOTATIONS;
    public static final XMLFeature DYNAMIC_VALIDATION;
    public static final XMLFeature LOAD_EXTERNAL_DTD;
    public static final XMLFeature XINCLUDE;
    public static final XMLFeature XINCLUDE_FIXUP_BASE_URIS;
    public static final XMLFeature XINCLUDE_FIXUP_LANGUAGE;
    private String control;
    private boolean state;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final XMLFeature[] VALUES;
    private static final long serialVersionUID = -1972881391399216524L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XMLFeature(String control, boolean initialState) {
        this.control = control;
        this.state = initialState;
    }

    private XMLFeature(String control) {
        this(control, false);
    }

    public String getControl() {
        return this.control;
    }

    public boolean getState() {
        return this.state;
    }

    public static XMLFeature fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            XMLFeature o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static XMLFeature fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return (this.state ? "on  " : "off ") + this.control;
    }

    public int compareTo(Object o) {
        XMLFeature feature = (XMLFeature)o;
        return this.control.compareTo(feature.control);
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !XMLFeature.class.desiredAssertionStatus();
        NAMESPACES = new XMLFeature("http://xml.org/sax/features/namespaces");
        NAMESPACE_PREFIX = new XMLFeature("http://xml.org/sax/features/namespace-prefixes");
        VALIDATION = new XMLFeature("http://xml.org/sax/features/validation");
        SCHEMA_VALIDATION = new XMLFeature("http://apache.org/xml/features/validation/schema");
        SCHEMA_FULL_CHECKING = new XMLFeature("http://apache.org/xml/features/validation/schema-full-checking");
        VALIDATE_ANNOTATIONS = new XMLFeature("http://apache.org/xml/features/validate-annotations");
        DYNAMIC_VALIDATION = new XMLFeature("http://apache.org/xml/features/validation/dynamic");
        LOAD_EXTERNAL_DTD = new XMLFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd");
        XINCLUDE = new XMLFeature("http://apache.org/xml/features/xinclude");
        XINCLUDE_FIXUP_BASE_URIS = new XMLFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", true);
        XINCLUDE_FIXUP_LANGUAGE = new XMLFeature("http://apache.org/xml/features/xinclude/fixup-language", true);
        VALUES = new XMLFeature[]{NAMESPACES, NAMESPACE_PREFIX, VALIDATION, SCHEMA_VALIDATION, SCHEMA_FULL_CHECKING, VALIDATE_ANNOTATIONS, DYNAMIC_VALIDATION, LOAD_EXTERNAL_DTD, XINCLUDE, XINCLUDE_FIXUP_BASE_URIS, XINCLUDE_FIXUP_LANGUAGE};
    }
}

