/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.swing.AbstractConfigEditor;
import org.crosswire.common.config.swing.ButtonPane;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.FormPane;

public class TreeConfigEditor
extends AbstractConfigEditor {
    protected static final String BLANK = "$$BLANK$$";
    protected JTree tree;
    protected transient ConfigureTreeModel ctm;
    protected JLabel title;
    protected JPanel deck;
    protected CardLayout layout;
    private static final long serialVersionUID = 3256720688860576049L;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    protected void initializeGUI() {
        JPanel panel = new JPanel();
        JPanel blank = new JPanel();
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        this.ctm = new ConfigureTreeModel();
        this.tree = new JTree();
        this.title = new JLabel();
        this.deck = new JPanel();
        this.layout = new CardLayout();
        blank.add(new JLabel(Msg.SELECT_SUBNODE.toString()));
        this.deck.setLayout(this.layout);
        this.deck.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.deck.add((Component)blank, BLANK);
        dtcr.setLeafIcon(TASK_ICON_SMALL);
        this.tree.setModel(this.ctm);
        this.tree.setCellRenderer(dtcr);
        this.tree.setPreferredSize(new Dimension(150, 150));
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setSelectionRow(0);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                TreeConfigEditor.this.selectCard();
            }
        });
        this.title.setIcon(TASK_ICON_LARGE);
        this.title.setFont(new Font(this.getFont().getName(), 0, 16));
        this.title.setPreferredSize(new Dimension(30, 30));
        this.title.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.title.setBackground(Color.gray);
        this.title.setForeground(Color.white);
        this.title.setOpaque(true);
        this.title.setText(Msg.PROPERTIES.toString());
        this.title.setAlignmentX(2.0f);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        panel.add("North", this.title);
        panel.add("Center", this.deck);
        this.setLayout(new BorderLayout(5, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("West", new JScrollPane(this.tree));
        this.add("Center", panel);
        this.add("South", new ButtonPane(this));
    }

    protected void updateTree() {
        int row = 0;
        while (row < this.tree.getRowCount()) {
            this.tree.expandRow(row++);
        }
        this.ctm.fireTreeStructureChanged(this);
    }

    protected void addChoice(String key, Choice model) {
        super.addChoice(key, model);
        String path = Config.getPath((String)model.getFullPath());
        FormPane card = (FormPane)this.decks.get(path);
        if (card != null && card.getParent() == null) {
            JScrollPane scroll = new JScrollPane(card);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            this.deck.add(path, scroll);
        }
    }

    protected void removeChoice(String key, Choice model) {
        super.removeChoice(key, model);
        String path = Config.getPath((String)model.getFullPath());
        FormPane card = (FormPane)this.decks.get(path);
        if (card != null && card.isEmpty()) {
            this.deck.remove(card.getParent());
        }
    }

    public void selectCard() {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj == null) {
            return;
        }
        this.title.setText(obj + " " + (Object)((Object)Msg.PROPERTIES));
        Object[] list = this.tree.getSelectionPath().getPath();
        StringBuffer path = new StringBuffer();
        for (int i = 1; i < list.length; ++i) {
            if (i > 1) {
                path.append(".");
            }
            path.append(list[i].toString());
        }
        String key = path.toString();
        if (this.decks.containsKey(key)) {
            this.layout.show(this.deck, key);
        } else {
            this.layout.show(this.deck, BLANK);
        }
        this.deck.repaint();
    }

    protected static class Node {
        private String name;
        private String path;

        protected Node(String path, String name) {
            this.path = path;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getFullName() {
            if (this.path.length() == 0 || this.name.length() == 0) {
                return this.path + this.name;
            }
            return this.path + "." + this.name;
        }
    }

    protected class ConfigureTreeModel
    implements TreeModel {
        protected EventListenerList listeners = new EventListenerList();
        private Node root = new Node("", "");

        protected ConfigureTreeModel() {
        }

        public Object getRoot() {
            return this.root;
        }

        protected List getChildren(String path) {
            ArrayList<String> retcode = new ArrayList<String>();
            Iterator it = TreeConfigEditor.this.config.getPaths();
            while (it.hasNext()) {
                int dot_pos;
                String temp = (String)it.next();
                if (!temp.startsWith(path) || temp.equals(path)) continue;
                if ((temp = temp.substring(path.length())).startsWith(".")) {
                    temp = temp.substring(1);
                }
                if ((dot_pos = temp.indexOf(".")) != -1) {
                    temp = temp.substring(0, dot_pos);
                }
                if (temp.length() <= 0 || retcode.contains(temp)) continue;
                retcode.add(temp);
            }
            return retcode;
        }

        public Object getChild(Object parent, int index) {
            String path = ((Node)parent).getFullName();
            String name = (String)this.getChildren(path).get(index);
            return new Node(path, name);
        }

        public int getChildCount(Object parent) {
            String path = ((Node)parent).getFullName();
            return this.getChildren(path).size();
        }

        public boolean isLeaf(Object node) {
            String path = ((Node)node).getFullName();
            return this.getChildren(path).size() == 0;
        }

        public void valueForPathChanged(TreePath path, Object value) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            String path = ((Node)parent).getFullName();
            List children = this.getChildren(path);
            return children.indexOf(child);
        }

        public void addTreeModelListener(TreeModelListener li) {
            this.listeners.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeConfigEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, li);
        }

        public void removeTreeModelListener(TreeModelListener li) {
            this.listeners.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeConfigEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, li);
        }

        protected void fireTreeStructureChanged(Object source) {
            this.fireTreeStructureChanged(source, new Object[]{this.root});
        }

        protected void fireTreeStructureChanged(Object source, Object[] path) {
            Object[] array = this.listeners.getListenerList();
            TreeModelEvent ev = null;
            for (int i = array.length - 2; i >= 0; i -= 2) {
                if (array[i] != (class$javax$swing$event$TreeModelListener == null ? TreeConfigEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (ev == null) {
                    ev = new TreeModelEvent(source, path);
                }
                ((TreeModelListener)array[i + 1]).treeStructureChanged(ev);
            }
        }
    }
}

