/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Iterator;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.XMLProcess;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.xml.sax.SAXException;

public class DictToOsis {
    private static final String BOOK_NAME = "Thayer";
    private static FieldPosition pos = new FieldPosition(0);

    public static void main(String[] args) {
        new DictToOsis().dump(BOOK_NAME);
    }

    public void dump(String name) {
        Books books = Books.installed();
        Book book = books.getBook(name);
        BookMetaData bmd = book.getBookMetaData();
        StringBuffer buf = new StringBuffer();
        try {
            Key keys = book.getGlobalKeyList();
            this.buildDocumentOpen(buf, bmd);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Key key = (Key)iter.next();
                BookData bdata = book.getData(key);
                SAXEventProvider osissep = bdata.getSAXEventProvider();
                try {
                    this.buildEntryOpen(buf, key.getName(), XMLUtil.writeToString((SAXEventProvider)osissep));
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
            }
            this.buildDocumentClose(buf);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(bmd.getInitials() + ".xml"), "UTF-8");
            writer.write(buf.toString());
            ((Writer)writer).close();
            XMLProcess parser = new XMLProcess();
            parser.parse(bmd.getInitials() + ".xml");
        }
        catch (BookException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildDocumentOpen(StringBuffer buf, BookMetaData bmd) {
        StringBuffer docBuffer = new StringBuffer();
        docBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        docBuffer.append("\n<osis");
        docBuffer.append("\n  xmlns=\"http://www.bibletechnologies.net/2003/OSIS/namespace\"");
        docBuffer.append("\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        docBuffer.append("\n  xsi:schemaLocation=\"http://www.bibletechnologies.net/2003/OSIS/namespace osisCore.2.1.xsd\">");
        docBuffer.append("\n<osisText osisIDWork=\"{0}\" osisRefWork=\"defaultReferenceScheme\" xml:lang=\"en\">");
        docBuffer.append("\n  <header>");
        docBuffer.append("\n    <work osisWork=\"{0}\">");
        docBuffer.append("\n      <title>{1}</title>");
        docBuffer.append("\n      <identifier type=\"OSIS\">Dict.{0}</identifier>");
        docBuffer.append("\n      <refSystem>Dict.{0}</refSystem>");
        docBuffer.append("\n    </work>");
        docBuffer.append("\n    <work osisWork=\"defaultReferenceScheme\">");
        docBuffer.append("\n      <refSystem>Dict.{0}</refSystem>");
        docBuffer.append("\n    </work>");
        docBuffer.append("\n  </header>");
        docBuffer.append("\n<div>");
        docBuffer.append('\n');
        MessageFormat msgFormat = new MessageFormat(docBuffer.toString());
        msgFormat.format(new Object[]{bmd.getInitials(), bmd.getName()}, buf, pos);
    }

    private void buildDocumentClose(StringBuffer buf) {
        buf.append("</div>\n</osisText>\n</osis>\n");
    }

    private void buildEntryOpen(StringBuffer buf, String entryName, String entryDef) {
        if (entryName.indexOf(32) != -1) {
            entryName = "x";
        }
        MessageFormat msgFormat = new MessageFormat("<div type=\"entry\" osisID=\"{0}\" canonical=\"true\"><seg type=\"x-form\"><seg type=\"x-orth\">{0}</seg></seg><seg type=\"x-def\">{1}</seg></div>\n");
        msgFormat.format(new Object[]{entryName, entryDef}, buf, pos);
    }
}

