/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.net.MalformedURLException;
import java.net.URL;
import org.crosswire.common.progress.Job;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.WebResource;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;

public class HttpSwordInstaller
extends AbstractSwordInstaller
implements Comparable {
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getType() {
        return "sword-http";
    }

    public int getSize(Book book) {
        return NetUtil.getSize((URL)this.toRemoteURL(book), (String)this.proxyHost, (Integer)this.proxyPort);
    }

    public URL toRemoteURL(Book book) {
        try {
            return new URL("http", this.host, this.directory + '/' + "packages/rawzip" + '/' + book.getInitials() + ".zip");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    protected void download(Job job, String dir, String file, URL dest) throws InstallException {
        block3: {
            try {
                URL url = new URL("http", this.host, dir + '/' + file);
                this.copy(job, url, dest);
            }
            catch (LucidException ex) {
                throw new InstallException((MsgBase)Msg.MISSING_FILE, ex);
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
    }

    private void copy(Job job, URL url, URL dest) throws LucidException {
        if (job != null) {
            job.setProgress(Msg.JOB_DOWNLOADING.toString());
        }
        WebResource wr = new WebResource(url, this.proxyHost, this.proxyPort);
        wr.copy(dest);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpSwordInstaller)) {
            return false;
        }
        HttpSwordInstaller that = (HttpSwordInstaller)object;
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        $assertionsDisabled = !HttpSwordInstaller.class.desiredAssertionStatus();
    }
}

