/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;

public class RawLDBackend
extends AbstractBackend {
    private boolean active;
    private static final byte SEPARATOR = 10;
    private static final int OFFSETSIZE = 4;
    private int datasize = -1;
    private RandomAccessFile datRaf;
    private RandomAccessFile idxRaf;
    private File datFile;
    private File idxFile;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RawLDBackend(SwordBookMetaData sbmd, File rootPath, int datasize) throws BookException {
        super(sbmd, rootPath);
        this.datasize = datasize;
        if (datasize != 2 && datasize != 4) {
            throw new BookException(Msg.TYPE_UNKNOWN);
        }
        String dataPath = sbmd.getProperty(ConfigEntryType.DATA_PATH);
        File baseurl = new File(rootPath, dataPath);
        String path = baseurl.getAbsolutePath();
        this.idxFile = new File(path + ".idx");
        this.datFile = new File(path + ".dat");
        if (!this.idxFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.idxFile.getAbsolutePath()});
        }
        if (!this.datFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.datFile.getAbsolutePath()});
        }
    }

    public final void activate(Lock lock) {
        try {
            this.idxRaf = new RandomAccessFile(this.idxFile, "r");
            this.datRaf = new RandomAccessFile(this.datFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.idxRaf = null;
            this.datRaf = null;
        }
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        try {
            this.idxRaf.close();
            this.datRaf.close();
        }
        catch (IOException ex) {
            log.error("failed to close files", (Throwable)ex);
        }
        this.idxRaf = null;
        this.datRaf = null;
        this.active = false;
    }

    public Key readIndex() {
        long entries;
        this.checkActive();
        SwordBookMetaData bmd = this.getBookMetaData();
        DefaultKeyList reply = new DefaultKeyList(null, bmd.getName());
        boolean isDailyDevotional = bmd.getBookCategory().equals(BookCategory.DAILY_DEVOTIONS);
        GregorianCalendar greg = new GregorianCalendar(1972, 0, 1);
        SimpleDateFormat nameDF = new SimpleDateFormat("d MMMM");
        int entrysize = 4 + this.datasize;
        try {
            entries = this.idxRaf.length() / (long)entrysize;
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
            return reply;
        }
        int entry = 0;
        while ((long)entry < entries) {
            try {
                byte[] buffer = SwordUtil.readRAF(this.idxRaf, entry * entrysize, entrysize);
                int offset = SwordUtil.decodeLittleEndian32(buffer, 0);
                int size = -1;
                switch (this.datasize) {
                    case 2: {
                        size = SwordUtil.decodeLittleEndian16(buffer, 4);
                        break;
                    }
                    case 4: {
                        size = SwordUtil.decodeLittleEndian32(buffer, 4);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(this.datasize);
                        }
                        break;
                    }
                }
                byte[] data = SwordUtil.readRAF(this.datRaf, offset, size);
                this.decipher(data);
                int keyend = SwordUtil.findByte(data, (byte)10);
                if (keyend == -1) {
                    DataPolice.report("Failed to find keyname. offset=" + offset + " data='" + new String(data) + "'");
                } else {
                    byte[] keydata = new byte[keyend];
                    System.arraycopy(data, 0, keydata, 0, keyend);
                    String keytitle = new String(keydata).trim();
                    if (keytitle.endsWith("\\")) {
                        keytitle = keytitle.substring(0, keytitle.length() - 1);
                    }
                    if (isDailyDevotional) {
                        String[] parts = StringUtil.splitAll((String)keytitle, (char)'.');
                        greg.set(2, Integer.parseInt(parts[0]) - 1);
                        greg.set(5, Integer.parseInt(parts[1]));
                        keytitle = nameDF.format(greg.getTime());
                    }
                    IndexKey key = new IndexKey(keytitle, offset, size, reply);
                    reply.addAll(key);
                }
            }
            catch (IOException ex) {
                log.error("Ignoring entry", (Throwable)ex);
            }
            catch (NumberFormatException e) {
                log.error("Ignoring entry", (Throwable)e);
            }
            ++entry;
        }
        return reply;
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        String charset = this.getBookMetaData().getBookCharset();
        if (!(key instanceof IndexKey)) {
            throw new BookException((MsgBase)Msg.BAD_KEY, new Object[]{ClassUtil.getShortClassName(key.getClass()), key.getName()});
        }
        IndexKey ikey = (IndexKey)key;
        try {
            byte[] data = SwordUtil.readRAF(this.datRaf, ikey.offset, ikey.size);
            int keyend = SwordUtil.findByte(data, (byte)10);
            if (keyend == -1) {
                throw new BookException(Msg.READ_FAIL);
            }
            int remainder = data.length - (keyend + 1);
            byte[] reply = new byte[remainder];
            System.arraycopy(data, keyend + 1, reply, 0, remainder);
            return SwordUtil.decode(key, reply, charset);
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)Msg.READ_FAIL, ex);
        }
    }

    public boolean isSupported() {
        return true;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !RawLDBackend.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)RawLDBackend.class);
    }

    static class IndexKey
    extends DefaultLeafKeyList {
        protected int offset;
        protected int size;

        protected IndexKey(String text, int offset, int size, Key parent) {
            super(text, text, parent);
            this.offset = offset;
            this.size = size;
        }

        protected IndexKey(String text) {
            super(text, text, null);
            this.offset = -1;
            this.size = -1;
        }

        public Object clone() {
            return super.clone();
        }
    }
}

