/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crosswire.common.history.HistoryEvent;
import org.crosswire.common.history.HistoryListener;
import org.crosswire.common.util.EventListenerList;

public class History {
    private List nav = new ArrayList();
    private Map history = new HashMap();
    private int backCount;
    private EventListenerList listeners = new EventListenerList();

    public Object select(int index) {
        int i = index;
        int size = this.nav.size();
        if (i > size) {
            i = size;
        } else if (i < 1) {
            i = 1;
        }
        this.backCount = i;
        this.fireHistoryChanged();
        return this.getCurrent();
    }

    public void add(Object obj) {
        if (this.nav.size() > 0) {
            this.nav.subList(this.backCount, this.nav.size()).clear();
        }
        this.nav.add(obj);
        ++this.backCount;
        this.visit(obj);
        this.fireHistoryChanged();
    }

    public List getPreviousList() {
        if (this.backCount > 0) {
            return Collections.unmodifiableList(this.nav.subList(0, this.backCount));
        }
        return Collections.EMPTY_LIST;
    }

    public List getNextList() {
        if (this.backCount < this.nav.size()) {
            return Collections.unmodifiableList(this.nav.subList(this.backCount, this.nav.size()));
        }
        return Collections.EMPTY_LIST;
    }

    public Object go(int i) {
        return this.select(this.backCount + i);
    }

    public Object getCurrent() {
        if (this.nav.size() > 0 && this.backCount > 0) {
            return this.nav.get(this.backCount - 1);
        }
        return null;
    }

    public synchronized void addHistoryListener(HistoryListener li) {
        this.listeners.add(HistoryListener.class, li);
    }

    public synchronized void removeHistoryListener(HistoryListener li) {
        this.listeners.remove(HistoryListener.class, li);
    }

    private void visit(Object obj) {
        this.history.put(obj, new Long(System.currentTimeMillis()));
    }

    private synchronized void fireHistoryChanged() {
        Object[] contents = this.listeners.getListenerList();
        HistoryEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$common$history$HistoryListener == null ? History.class$("org.crosswire.common.history.HistoryListener") : class$org$crosswire$common$history$HistoryListener)) continue;
            if (ev == null) {
                ev = new HistoryEvent(this);
            }
            ((HistoryListener)contents[i + 1]).historyChanged(ev);
        }
    }
}

