/**
 * Distribution License:
 * BibleDesktop is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2 as published by
 * the Free Software Foundation. This program is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * The License is available on the internet at:
 *       http://www.gnu.org/copyleft/gpl.html
 * or by writing to:
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA 02111-1307, USA
 *
 * Copyright: 2005
 *     The copyright to this program is held by it's authors.
 *
 * ID: $Id: SiteEditorFactory.java 776 2005-09-10 09:07:17Z dmsmith $
 */
package org.crosswire.bibledesktop.book.install;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;

import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.book.install.Installer;

/**
 * Factory for SiteEditors.
 * 
 * @see gnu.gpl.License for license details.
 *      The copyright to this program is held by it's authors.
 * @author DM Smith [dmsmith555 at yahoo dot com]
 */
public final class SiteEditorFactory
{
    /**
     * Prevent Use
     */
    private SiteEditorFactory()
    {
    }

    /**
     * Create a new SiteEditor
     */
    public static SiteEditor createSiteEditor(Installer installer)
    {
        try
        {
            Properties properties = ResourceUtil.getProperties(SiteEditorFactory.class);
            String className = properties.getProperty(installer.getType());
            Class clazz = Class.forName(className);
            SiteEditor editor = (SiteEditor) clazz.newInstance();
            editor.setInstaller(installer);
            return editor;
        }
        catch (MissingResourceException e)
        {
            assert false : e;
        }
        catch (IOException e)
        {
            assert false : e;
        }
        catch (ClassNotFoundException e)
        {
            assert false : e;
        }
        catch (InstantiationException e)
        {
            assert false : e;
        }
        catch (IllegalAccessException e)
        {
            assert false : e;
        }
        return null;
    }
}
