/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.swing.plaf.MetalLFCustoms;
import org.crosswire.common.swing.plaf.OtherLFCustoms;
import org.crosswire.common.swing.plaf.WindowsLFCustoms;

public final class LookAndFeelUtil {
    private static Class currentLAF;
    private static Class defaultLAF;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LookAndFeelUtil() {
    }

    public static void initialize() {
    }

    public static Class getLookAndFeel() {
        if (currentLAF == null) {
            return defaultLAF;
        }
        return currentLAF;
    }

    public static void setLookAndFeel(Class newLaFClass) throws InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        LookAndFeel laf = (LookAndFeel)newLaFClass.newInstance();
        if (currentLAF != null && !currentLAF.equals(newLaFClass)) {
            JOptionPane.showMessageDialog(null, Msg.PLAF_CHANGE);
        } else {
            UIManager.setLookAndFeel(laf);
        }
        currentLAF = newLaFClass;
    }

    private static void customizeBDLookandFeel() {
        String currentLF = UIManager.getLookAndFeel().getClass().getName();
        if (currentLF.indexOf("MetalLookAndFeel") != -1) {
            new MetalLFCustoms().initUIDefaults();
        } else if (currentLF.indexOf("WindowsLookAndFeel") != -1) {
            new WindowsLFCustoms().initUIDefaults();
        } else {
            new OtherLFCustoms().initUIDefaults();
        }
    }

    static {
        block9: {
            $assertionsDisabled = !LookAndFeelUtil.class.desiredAssertionStatus();
            defaultLAF = MetalLookAndFeel.class;
            String systemLAF = UIManager.getSystemLookAndFeelClassName();
            try {
                if (systemLAF.indexOf("WindowsLookAndFeel") != -1 || systemLAF.indexOf("AquaLookAndfeel") != -1) {
                    UIManager.setLookAndFeel(systemLAF);
                    defaultLAF = Class.forName(systemLAF);
                }
            }
            catch (ClassNotFoundException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (InstantiationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IllegalAccessException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        LookAndFeelUtil.customizeBDLookandFeel();
    }
}

