/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.crosswire.common.config.swing.AbstractConfigEditor;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.EdgeBorder;
import org.crosswire.common.swing.FormPane;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Reporter;

public class WizardConfigEditor
extends AbstractConfigEditor {
    private static final String NEXT = "WizardNext";
    private static final String CANCEL = "WizardCancel";
    private static final String FINISH = "WizardFinish";
    private static final String HELP = "WizardHelp";
    private static final String BACK = "WizardBack";
    private transient ActionFactory actions;
    private int posn;
    private int wcards;
    private List names;
    private JLabel title;
    private JPanel deck;
    private CardLayout layout;
    private JButton finish;
    private JButton next;
    private static final Logger log = Logger.getLogger(WizardConfigEditor.class);
    private static final long serialVersionUID = 3258416148742484276L;

    protected void initializeGUI() {
        this.actions = new ActionFactory(WizardConfigEditor.class, this);
        this.names = new ArrayList();
        this.layout = new CardLayout();
        this.deck = new JPanel(this.layout);
        Iterator it = this.config.getNames();
        while (it.hasNext()) {
            int last_dot;
            String key = (String)it.next();
            String path = key.substring(0, last_dot = key.lastIndexOf(46));
            FormPane card = (FormPane)this.decks.get(path);
            if (card.getParent() != null) continue;
            JScrollPane scroll = new JScrollPane(card);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            this.deck.add(path, scroll);
            ++this.wcards;
            this.names.add(path.replace('.', ' '));
        }
        this.title = new JLabel(Msg.PROPERTIES.toString(), 2);
        this.title.setIcon(TASK_ICON_LARGE);
        this.title.setFont(new Font(this.getFont().getName(), 0, 16));
        this.title.setPreferredSize(new Dimension(30, 30));
        this.title.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.title.setBackground(Color.gray);
        this.title.setForeground(Color.white);
        this.title.setOpaque(true);
        this.title.setText(this.names.get(1) + Msg.PROPERTIES_POSN.toString(new Object[]{new Integer(1), new Integer(this.wcards)}));
        this.deck.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        panel.add((Component)this.title, "First");
        panel.add((Component)this.deck, "Center");
        this.setLayout(new BorderLayout(5, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panel, "Center");
        this.add((Component)this.getButtonPane(), "Last");
        SwingUtilities.updateComponentTreeUI(this);
    }

    protected void updateTree() {
    }

    private JComponent getButtonPane() {
        this.finish = new JButton(this.actions.getAction(FINISH));
        this.next = new JButton(this.actions.getAction(NEXT));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2, 10, 10));
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttons.add(new JButton(this.actions.getAction(HELP)));
        buttons.add(new JButton(this.actions.getAction(CANCEL)));
        buttons.add(new JButton(this.actions.getAction(BACK)));
        buttons.add(this.next);
        buttons.add(this.finish);
        this.actions.getAction(HELP).setEnabled(false);
        this.actions.getAction(BACK).setEnabled(false);
        JPanel retcode = new JPanel(new BorderLayout(10, 10));
        retcode.setBorder(new EdgeBorder(1));
        retcode.add((Component)buttons, "After");
        return retcode;
    }

    public void doWizardCancel() {
        this.hideDialog();
    }

    public void doWizardHelp() {
    }

    public void doWizardBack() {
        this.move(-1);
    }

    public void doWizardNext() {
        this.move(1);
    }

    public void doWizardFinish(ActionEvent ev) {
        try {
            this.screenToLocal();
            this.al.actionPerformed(ev);
            this.hideDialog();
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, ex);
        }
    }

    private void move(int dirn) {
        if (dirn == -1 && this.posn > 0) {
            this.layout.previous(this.deck);
            --this.posn;
        }
        if (dirn == 1 && this.posn < this.wcards - 1) {
            this.layout.next(this.deck);
            ++this.posn;
        }
        this.title.setText(this.names.get(this.posn) + Msg.PROPERTIES_POSN.toString(new Object[]{new Integer(this.posn + 1), new Integer(this.wcards)}));
        this.actions.getAction(BACK).setEnabled(this.posn != 0);
        this.actions.getAction(NEXT).setEnabled(this.posn != this.wcards - 1);
        if (this.posn == this.wcards - 1) {
            this.dialog.getRootPane().setDefaultButton(this.finish);
        } else {
            this.dialog.getRootPane().setDefaultButton(this.next);
        }
    }

    public void showDialog(Component parent) {
        this.dialog = new JDialog((JFrame)SwingUtilities.getRoot(parent));
        this.dialog.getRootPane().setDefaultButton(this.next);
        this.dialog.getContentPane().add(this);
        this.dialog.setTitle(this.config.getTitle());
        this.dialog.setSize(800, 500);
        this.dialog.pack();
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
        log.debug("Modal fails on SunOS, take care. os.name=" + System.getProperty("os.name"));
        if (!"SunOS".equals(System.getProperty("os.name"))) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

