/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerFactory;
import org.crosswire.jsword.book.install.sword.HttpSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;

public class HttpSwordInstallerFactory
implements InstallerFactory {
    public Installer createInstaller() {
        return new HttpSwordInstaller();
    }

    public Installer createInstaller(String installerDefinition) {
        String[] parts = installerDefinition.split(",", 4);
        if (parts.length < 4) {
            throw new IllegalArgumentException(Msg.INVALID_DEFINITION.toString(installerDefinition));
        }
        HttpSwordInstaller reply = new HttpSwordInstaller();
        reply.setHost(parts[0]);
        reply.setDirectory(parts[1]);
        if (parts[2].length() > 0) {
            reply.setProxyHost(parts[2]);
            if (parts[5].length() > 0) {
                reply.setProxyPort(Integer.valueOf(parts[3]));
            }
        }
        return reply;
    }
}

