/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.util.Convert;

public class MapTableModel
extends AbstractTableModel {
    private List list;
    private Map map;
    private String[] colNames = new String[]{Msg.KEYS.toString(), Msg.VALUES.toString()};
    private static final long serialVersionUID = 3546365041277352241L;

    public MapTableModel() {
        this(null);
    }

    public MapTableModel(Map map) {
        this.list = new ArrayList();
        this.setMap(map);
    }

    public void setMap(Map map) {
        this.map = map;
        this.list.clear();
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                Object k = me.getKey();
                Object v = me.getValue();
                if (k == null || v == null) continue;
                String key = k.toString().trim();
                String value = v.toString().trim();
                if (key.length() == 0) continue;
                this.list.add(new StringPair(key, value));
            }
        }
        this.fireTableDataChanged();
    }

    public void add(String key, String aValue) {
        String value = aValue;
        if (value == null) {
            value = "";
        }
        if (key == null || key.length() == 0) {
            return;
        }
        if (this.map.containsKey(key) && value.equals(this.map.get(key))) {
            return;
        }
        this.map.put(key, value);
        this.setMap(this.map);
    }

    public void remove(String key) {
        if (this.map != null) {
            this.map.remove(key);
            this.setMap(this.map);
        }
    }

    public void update(String oldkey, String newkey, String newvalue) {
        if (this.map != null) {
            if (!oldkey.equals(newkey)) {
                this.map.remove(oldkey);
            }
            this.add(newkey, newvalue);
        }
    }

    public String getValue() {
        return Convert.map2String(this.map);
    }

    public int getColumnCount() {
        if (this.list == null) {
            return 0;
        }
        return 2;
    }

    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.list == null) {
            return null;
        }
        StringPair entry = (StringPair)this.list.get(row);
        if (col == 0) {
            return entry.getKey();
        }
        return entry.getValue();
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public void setColumnName(int col, String name) {
        this.colNames[col] = name;
    }

    private static final class StringPair {
        private String key;
        private String value;

        public StringPair(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

