/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.util.Logger;

public final class JobManager {
    private static List listeners = new ArrayList();
    private static Set jobs = new HashSet();
    private static final Logger log = Logger.getLogger(JobManager.class);

    private JobManager() {
    }

    public static Job createJob(String description, URL predicturl, Thread work, boolean fakeupdates) {
        Job job = new Job(description, predicturl, work, fakeupdates);
        jobs.add(job);
        log.debug("job starting: " + job.getJobDescription());
        return job;
    }

    public static Job createJob(String description, Thread work, boolean fakeupdates) {
        return JobManager.createJob(description, null, work, fakeupdates);
    }

    public static Job createJob(String description, URL predicturl, boolean fakeupdates) {
        return JobManager.createJob(description, predicturl, null, fakeupdates);
    }

    public static Job createJob(String description, boolean fakeupdates) {
        return JobManager.createJob(description, null, null, fakeupdates);
    }

    public static synchronized void addWorkListener(WorkListener li) {
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        temp.addAll(listeners);
        if (!temp.contains(li)) {
            temp.add(li);
            listeners = temp;
        }
    }

    public static synchronized void removeWorkListener(WorkListener li) {
        if (listeners.contains(li)) {
            ArrayList temp = new ArrayList();
            temp.addAll(listeners);
            temp.remove(li);
            listeners = temp;
        }
    }

    public static synchronized Set getJobs() {
        HashSet reply = new HashSet();
        reply.addAll(jobs);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireWorkProgressed(Job job, boolean predicted) {
        WorkEvent ev = new WorkEvent(job, predicted);
        ArrayList temp = new ArrayList();
        Class clazz = JobManager.class;
        synchronized (clazz) {
            temp.addAll(listeners);
        }
        if (listeners != null) {
            int count = temp.size();
            for (int i = 0; i < count; ++i) {
                ((WorkListener)temp.get(i)).workProgressed(ev);
            }
        }
        Class clazz2 = JobManager.class;
        synchronized (clazz2) {
            if (job.isFinished()) {
                log.debug("job finished: " + job.getJobDescription());
                jobs.remove(job);
            }
        }
    }
}

