/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.ExceptionPane;
import org.crosswire.common.swing.FieldLayout;
import org.crosswire.common.swing.MapTableModel;
import org.crosswire.common.util.Convert;

public class MapField
extends JPanel
implements Field {
    private static final String ADD = "AddMapEntry";
    private static final String REMOVE = "RemoveMapEntry";
    private static final String UPDATE = "UpdateMapEntry";
    private transient ActionFactory actions;
    private NamedMapTableModel tableModel = new NamedMapTableModel();
    private JTable table = new JTable(this.tableModel);
    private Class superclass;
    private static final long serialVersionUID = 3257849861683296313L;

    public MapField() {
        this.actions = new ActionFactory(MapField.class, this);
        JPanel buttons = new JPanel(new FlowLayout());
        this.table.setFont(new Font("Monospaced", 0, 12));
        this.table.setPreferredScrollableViewportSize(new Dimension(30, 100));
        this.table.setColumnSelectionAllowed(false);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        buttons.add(new JButton(this.actions.getAction(ADD)));
        buttons.add(new JButton(this.actions.getAction(REMOVE)));
        buttons.add(new JButton(this.actions.getAction(UPDATE)));
        TitledBorder title = BorderFactory.createTitledBorder(Msg.COMPONENT_EDITOR.toString());
        Border pad = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(BorderFactory.createCompoundBorder(title, pad));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "Last");
    }

    public void setChoice(Choice param) {
    }

    public String getValue() {
        return this.tableModel.getValue();
    }

    public void setValue(String value) {
        this.setMap(Convert.string2Hashtable(value, this.superclass));
    }

    public void setMap(Map value) {
        this.tableModel.setMap(value);
        this.table.setModel(this.tableModel);
        this.table.getColumnModel().getColumn(0).setWidth(15);
    }

    public JComponent getComponent() {
        return this;
    }

    public void doAddEntry() {
        InputPane input = new InputPane();
        if (JOptionPane.showConfirmDialog(this, input, Msg.NEW_CLASS.toString(), 2) == 0) {
            String newClass = input.classField.getText();
            String newName = input.nameField.getText();
            if (this.isValid(newClass)) {
                this.tableModel.add(newName, newClass);
            }
        }
    }

    public void doUpdateEntry() {
        InputPane input = new InputPane();
        input.nameField.setText(this.currentKey());
        input.classField.setText(this.currentValue());
        if (JOptionPane.showConfirmDialog(this, input, Msg.EDIT_CLASS.toString(), 2) == 0) {
            String newClass = input.classField.getText();
            String newName = input.nameField.getText();
            if (this.isValid(newClass)) {
                this.tableModel.update(this.currentKey(), newName, newClass);
            }
        }
    }

    public void doRemoveEntry() {
        this.tableModel.remove(this.currentKey());
    }

    public boolean isValid(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            if (!this.superclass.isAssignableFrom(clazz)) {
                throw new ClassCastException(Msg.BAD_SUPERCLASS.toString(new Object[]{name, this.superclass}));
            }
            return true;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this, Msg.CLASS_NOT_FOUND.toString(name));
        }
        catch (Exception ex) {
            ExceptionPane.showExceptionDialog(this, ex);
        }
        return false;
    }

    private String currentKey() {
        return (String)this.tableModel.getValueAt(this.table.getSelectedRow(), 0);
    }

    private String currentValue() {
        return (String)this.tableModel.getValueAt(this.table.getSelectedRow(), 1);
    }

    static class InputPane
    extends JPanel {
        protected JTextField nameField = new JTextField();
        protected JTextField classField = new JTextField(20);
        private static final long serialVersionUID = 3257849861683296313L;

        protected InputPane() {
            super(new FieldLayout(10, 10));
            this.add(new JLabel(Msg.NAME + ":"));
            this.add(this.nameField);
            this.add(new JLabel(Msg.CLASS + ":"));
            this.add(this.classField);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
    }

    static class NamedMapTableModel
    extends MapTableModel {
        private static final long serialVersionUID = 3257566217748427059L;

        protected NamedMapTableModel() {
            super(new Hashtable());
        }

        public String getColumnName(int col) {
            return col == 0 ? Msg.NAME.toString() : Msg.CLASS.toString();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

