/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search;

import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.search.Index;
import org.crosswire.jsword.book.search.IndexManager;
import org.crosswire.jsword.book.search.IndexManagerFactory;
import org.crosswire.jsword.book.search.Searcher;

public final class SearcherFactory {
    private static final Logger log = Logger.getLogger((Class)SearcherFactory.class);

    private SearcherFactory() {
    }

    public static Searcher createSearcher(Book book) throws InstantiationException {
        try {
            IndexManager imanager = IndexManagerFactory.getIndexManager();
            Index index = imanager.getIndex(book);
            Class impl = ClassUtil.getImplementor((Class)Searcher.class);
            Searcher parser = (Searcher)impl.newInstance();
            parser.init(index);
            return parser;
        }
        catch (Exception ex) {
            log.error("createSearcher failed", (Throwable)ex);
            throw new InstantiationException();
        }
    }
}

