/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.HashMap;
import java.util.Map;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.filter.gbf.GBFTags;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.book.filter.gbf.TagBuilder;

public final class GBFTagBuilders {
    private static final Logger log = Logger.getLogger((Class)GBFTagBuilders.class);
    private static final Map BUILDERS = new HashMap();

    private GBFTagBuilders() {
    }

    public static Tag getTag(String name) {
        Tag tag = null;
        int length = name.length();
        if (length > 0) {
            TagBuilder builder = null;
            builder = length == 2 ? (TagBuilder)BUILDERS.get(name) : (TagBuilder)BUILDERS.get(name.substring(0, 2));
            Tag reply = null;
            if (builder != null) {
                reply = builder.createTag(name);
            }
            if (reply == null) {
                log.warn("Ignoring tag of <" + name + ">");
            }
        }
        return tag;
    }

    public static Tag getTextTag(String text) {
        return new GBFTags.TextTag(text);
    }

    static {
        DefaultEndTagBuilder defaultEndTagBuilder = new DefaultEndTagBuilder();
        IgnoredTagBuilder ignoreTagBuilder = new IgnoredTagBuilder();
        BUILDERS.put("FB", new BoldStartTagBuilder());
        BUILDERS.put("Fb", defaultEndTagBuilder);
        BUILDERS.put("FI", new ItalicStartTagBuilder());
        BUILDERS.put("Fi", defaultEndTagBuilder);
        BUILDERS.put("FR", new RedLetterStartTagBuilder());
        BUILDERS.put("Fr", defaultEndTagBuilder);
        BUILDERS.put("FU", new UnderlineStartTagBuilder());
        BUILDERS.put("Fu", defaultEndTagBuilder);
        BUILDERS.put("RX", new CrossRefStartTagBuilder());
        BUILDERS.put("Rx", defaultEndTagBuilder);
        BUILDERS.put("CL", new EndOfLineTagBuilder());
        BUILDERS.put("CM", new ParagraphTagBuilder());
        BUILDERS.put("RF", new FootnoteStartTagBuilder());
        BUILDERS.put("Rf", new FootnoteEndTagBuilder());
        BUILDERS.put("RB", new TextFootnoteTagBuilder());
        BUILDERS.put("TS", new HeaderStartTagBuilder());
        BUILDERS.put("Ts", defaultEndTagBuilder);
        BUILDERS.put("TB", new PsalmTitleStartTagBuilder());
        BUILDERS.put("Tb", defaultEndTagBuilder);
        BUILDERS.put("TH", new TitleStartTagBuilder());
        BUILDERS.put("Th", defaultEndTagBuilder);
        BUILDERS.put("BA", ignoreTagBuilder);
        BUILDERS.put("BC", ignoreTagBuilder);
        BUILDERS.put("BI", ignoreTagBuilder);
        BUILDERS.put("BN", ignoreTagBuilder);
        BUILDERS.put("BO", ignoreTagBuilder);
        BUILDERS.put("BP", ignoreTagBuilder);
        BUILDERS.put("JR", new JustifyRightTagBuilder());
        BUILDERS.put("JL", ignoreTagBuilder);
        BUILDERS.put("FO", new OTQuoteStartTagBuilder());
        BUILDERS.put("Fo", defaultEndTagBuilder);
        BUILDERS.put("PP", new PoetryStartTagBuilder());
        BUILDERS.put("Pp", defaultEndTagBuilder);
        StrongsWordTagBuilder builder = new StrongsWordTagBuilder();
        BUILDERS.put("WH", builder);
        BUILDERS.put("WG", builder);
        BUILDERS.put("WT", new StrongsMorphTagBuilder());
    }

    private static final class UnderlineStartTagBuilder
    implements TagBuilder {
        private UnderlineStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.UnderlineStartTag(name);
        }
    }

    private static final class TitleStartTagBuilder
    implements TagBuilder {
        private TitleStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.TitleStartTag(name);
        }
    }

    private static final class TextFootnoteTagBuilder
    implements TagBuilder {
        private TextFootnoteTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.TextFootnoteTag(name);
        }
    }

    private static final class StrongsWordTagBuilder
    implements TagBuilder {
        private StrongsWordTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.StrongsWordTag(name);
        }
    }

    private static final class StrongsMorphTagBuilder
    implements TagBuilder {
        private StrongsMorphTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.StrongsMorphTag(name);
        }
    }

    private static final class RedLetterStartTagBuilder
    implements TagBuilder {
        private RedLetterStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.RedLetterStartTag(name);
        }
    }

    private static final class PsalmTitleStartTagBuilder
    implements TagBuilder {
        private PsalmTitleStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.PsalmStartTag(name);
        }
    }

    private static final class PoetryStartTagBuilder
    implements TagBuilder {
        private PoetryStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.PoetryStartTag(name);
        }
    }

    private static final class ParagraphTagBuilder
    implements TagBuilder {
        private ParagraphTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.ParagraphTag(name);
        }
    }

    private static final class OTQuoteStartTagBuilder
    implements TagBuilder {
        private OTQuoteStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.OTQuoteStartTag(name);
        }
    }

    private static final class JustifyRightTagBuilder
    implements TagBuilder {
        private JustifyRightTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.JustifyRightTag(name);
        }
    }

    private static final class ItalicStartTagBuilder
    implements TagBuilder {
        private ItalicStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.ItalicStartTag(name);
        }
    }

    private static final class IgnoredTagBuilder
    implements TagBuilder {
        private IgnoredTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.IgnoredTag(name);
        }
    }

    private static final class HeaderStartTagBuilder
    implements TagBuilder {
        private HeaderStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.HeaderStartTag(name);
        }
    }

    private static final class FootnoteEndTagBuilder
    implements TagBuilder {
        private FootnoteEndTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.FootnoteEndTag(name);
        }
    }

    private static final class FootnoteStartTagBuilder
    implements TagBuilder {
        private FootnoteStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.FootnoteStartTag(name);
        }
    }

    private static final class EndOfLineTagBuilder
    implements TagBuilder {
        private EndOfLineTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.EOLTag(name);
        }
    }

    private static final class DefaultEndTagBuilder
    implements TagBuilder {
        private DefaultEndTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.DefaultEndTag(name);
        }
    }

    private static final class CrossRefStartTagBuilder
    implements TagBuilder {
        private CrossRefStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.CrossRefStartTag(name);
        }
    }

    private static final class BoldStartTagBuilder
    implements TagBuilder {
        private BoldStartTagBuilder() {
        }

        public Tag createTag(String name) {
            return new GBFTags.BoldStartTag(name);
        }
    }
}

