/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.io.Serializable;
import org.crosswire.common.xml.TransformingSAXEventProvider;

public final class XSLTProperty
implements Serializable {
    public static final XSLTProperty STRONGS_NUMBERS;
    public static final XSLTProperty MORPH;
    public static final XSLTProperty START_VERSE_ON_NEWLINE;
    public static final XSLTProperty VERSE_NUMBERS;
    public static final XSLTProperty CV;
    public static final XSLTProperty BCV;
    public static final XSLTProperty NO_VERSE_NUMBERS;
    public static final XSLTProperty TINY_VERSE_NUMBERS;
    public static final XSLTProperty NOTES;
    public static final XSLTProperty XREF;
    private String name;
    private boolean defaultState;
    private boolean state;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final XSLTProperty[] VALUES;
    private static final long serialVersionUID = 3257567325749326905L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XSLTProperty(String name, boolean defaultState) {
        this.name = name;
        this.defaultState = defaultState;
        this.state = defaultState;
    }

    public String getName() {
        return this.name;
    }

    public boolean getDefault() {
        return this.defaultState;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean newState) {
        this.state = newState;
    }

    public void setProperty(TransformingSAXEventProvider provider) {
        provider.setParameter(this.name, (Object)Boolean.toString(this.state));
    }

    public static void setProperties(TransformingSAXEventProvider provider) {
        for (int i = 0; i < VALUES.length; ++i) {
            VALUES[i].setProperty(provider);
        }
    }

    public static XSLTProperty fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            XSLTProperty o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static XSLTProperty fromInteger(int i) {
        return VALUES[i];
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !XSLTProperty.class.desiredAssertionStatus();
        STRONGS_NUMBERS = new XSLTProperty("Strongs", false);
        MORPH = new XSLTProperty("Morph", false);
        START_VERSE_ON_NEWLINE = new XSLTProperty("VLine", false);
        VERSE_NUMBERS = new XSLTProperty("VNum", true);
        CV = new XSLTProperty("CVNum", false);
        BCV = new XSLTProperty("BCVNum", false);
        NO_VERSE_NUMBERS = new XSLTProperty("NoVNum", false);
        TINY_VERSE_NUMBERS = new XSLTProperty("TinyVNum", true);
        NOTES = new XSLTProperty("Notes", true);
        XREF = new XSLTProperty("XRef", true);
        VALUES = new XSLTProperty[]{STRONGS_NUMBERS, MORPH, START_VERSE_ON_NEWLINE, VERSE_NUMBERS, CV, BCV, NO_VERSE_NUMBERS, TINY_VERSE_NUMBERS, NOTES, XREF};
    }
}

