/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class JnlpParser {
    private JnlpParser() {
    }

    private static LaunchDesc getLaunchDesc(String string) {
        LaunchDesc launchDesc = null;
        try {
            launchDesc = LaunchDescFactory.buildDescriptor((String)string);
        }
        catch (Exception exception) {
            return null;
        }
        return launchDesc;
    }

    public static String parseJnlpHref(File file) {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray, 0, n);
            fileInputStream.close();
            String string2 = new String(byArray);
            XMLNode xMLNode = new XMLParser(string2).parse();
            string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public static String parseJnlpInfo(File file, String string) {
        String string2 = null;
        LaunchDesc launchDesc = JnlpParser.getLaunchDesc(file.toString());
        InformationDesc informationDesc = launchDesc.getInformation();
        if (string.compareToIgnoreCase("codebase") == 0) {
            URL uRL = launchDesc.getCodebase();
            string2 = uRL.toString();
        } else if (string.compareToIgnoreCase("title") == 0) {
            string2 = informationDesc.getTitle();
        } else if (string.compareToIgnoreCase("vendor") == 0) {
            string2 = informationDesc.getVendor();
        }
        return string2;
    }

    public static List parseJnlpRefFiles(File file) {
        final ArrayList arrayList = new ArrayList();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray, 0, n);
            fileInputStream.close();
            String string = new String(byArray);
            XMLNode xMLNode = new XMLParser(string).parse();
            XMLUtils.visitElements((XMLNode)xMLNode, (String)"<resources><jar>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

                public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                    String string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
                    if (string != null) {
                        arrayList.add(string);
                    }
                }
            });
            XMLUtils.visitElements((XMLNode)xMLNode, (String)"<resources><nativelib>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

                public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                    String string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
                    if (string != null) {
                        arrayList.add(string);
                    }
                }
            });
            XMLUtils.visitElements((XMLNode)xMLNode, (String)"<information><icon>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

                public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                    String string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
                    if (string != null) {
                        arrayList.add(string);
                    }
                }
            });
            String string2 = System.getProperty("os.name");
            XMLNode xMLNode2 = XMLUtils.getElementWithAttribute((XMLNode)xMLNode, (String)"<resources>", (String)"os", (String)string2);
            if (xMLNode2 != null) {
                XMLUtils.visitElements((XMLNode)xMLNode2, (String)"<jar>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

                    public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                        String string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
                        if (string != null) {
                            arrayList.add(string);
                        }
                    }
                });
                XMLUtils.visitElements((XMLNode)xMLNode2, (String)"<nativelib>", (XMLUtils.ElementVisitor)new XMLUtils.ElementVisitor(){

                    public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                        String string = XMLUtils.getAttribute((XMLNode)xMLNode, (String)"", (String)"href");
                        if (string != null) {
                            arrayList.add(string);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }
}

