/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class XPMenuUI
extends WindowsMenuUI {
    static int i = 0;
    private JMenu menu;
    private FocusHandler focusHandler;

    public static ComponentUI createUI(JComponent x) {
        return new XPMenuUI((JMenu)x);
    }

    XPMenuUI(JMenu menu) {
        this.menu = menu;
    }

    protected void installListeners() {
        super.installListeners();
        this.focusHandler = new FocusHandler();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", this.focusHandler);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.focusHandler);
    }

    public void paint(Graphics g, JComponent c) {
        Window window = SwingUtilities.windowForComponent(c);
        Color oldColor = g.getColor();
        if (!window.isActive()) {
            g.setColor(this.disabledForeground);
        }
        super.paint(g, c);
        g.setColor(oldColor);
    }

    private class FocusHandler
    implements PropertyChangeListener {
        private FocusHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.getSelectedPath().length > 0) {
                manager.clearSelectedPath();
                return;
            }
            XPMenuUI.this.menu.repaint();
            XPMenuUI.this.menu.validate();
        }
    }
}

