/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class LookAndFeelPatchManager {
    private static final String SYSPROP_PATCHES = "net.java.plaf.patches";
    private static final String SYSPROP_ADDITIONAL_PATCHES = "net.java.plaf.additionalpatches";
    private static final String[] LAF_PATCHES = new String[]{"net.java.plaf.windows.common.WindowsMenuPatch", "net.java.plaf.windows.xp.XPMenuPatch", "net.java.plaf.windows.xp.XPMenuItemPatch", "net.java.plaf.windows.xp.XPTextFieldMarginPatch", "net.java.plaf.windows.xp.XPComboBoxMarginPatch", "net.java.plaf.windows.xp.XPPasswordFieldPatch", "net.java.plaf.windows.common.WindowsTextFieldPatch", "net.java.plaf.windows.xp.XPIconPatch", "net.java.plaf.windows.common.WindowsOptionPanePatch", "net.java.plaf.windows.xp.XPScrollBarPatch", "net.java.plaf.windows.common.WindowsFontPatch", "net.java.plaf.windows.common.WindowsRadioButtonPatch", "net.java.plaf.windows.xp.XPButtonPatch"};
    private static Collection m_allPatches;
    private static Collection m_installedPatches;

    public static void initialize() {
        ArrayList<String> patchClasses = new ArrayList<String>(10);
        String patches = System.getProperty(SYSPROP_PATCHES);
        if (patches != null) {
            LookAndFeelPatchManager.addClasses(patchClasses, patches);
        } else {
            patchClasses.addAll(Arrays.asList(LAF_PATCHES));
        }
        String extraPatches = System.getProperty(SYSPROP_ADDITIONAL_PATCHES);
        if (extraPatches != null) {
            LookAndFeelPatchManager.addClasses(patchClasses, extraPatches);
        }
        m_allPatches = new ArrayList(patchClasses.size());
        Iterator i = patchClasses.iterator();
        while (i.hasNext()) {
            String patchName = (String)i.next();
            try {
                Class<?> c = Class.forName(patchName);
                Object o = c.newInstance();
                if (!(o instanceof LookAndFeelPatch)) continue;
                m_allPatches.add(o);
            }
            catch (Exception e) {
                System.err.println("Failed to install patch " + patchName);
                e.printStackTrace();
            }
        }
        LookAndFeelPatchManager.patch();
    }

    private static void patch() {
        m_installedPatches = new ArrayList();
        Environment env = new Environment();
        Iterator i = m_allPatches.iterator();
        while (i.hasNext()) {
            LookAndFeelPatch patch = (LookAndFeelPatch)i.next();
            if (!patch.isApplicable(env)) continue;
            patch.patch(env);
            m_installedPatches.add(patch);
        }
    }

    private static void addClasses(Collection coll, String classList) {
        StringTokenizer tok = new StringTokenizer(classList, System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            coll.add(tok.nextToken());
        }
    }
}

