/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;

public class DefaultListCellRenderer
extends javax.swing.DefaultListCellRenderer {
    private JList list;
    private boolean cellHasFocus;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.list = list;
        this.cellHasFocus = cellHasFocus;
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected && cellHasFocus) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else if (this.isFocusPermanentlyLost() && isSelected) {
            Color focusLostSelectionColor = UIManager.getColor("Label.background");
            this.setBackground(focusLostSelectionColor);
            this.setForeground(list.getForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    protected boolean isFocusPermanentlyLost() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = kfm.getPermanentFocusOwner();
        if (component == null) {
            return this.hasCellFocus();
        }
        Window window = this.windowForComponent(this.getList());
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            return true;
        }
        return !component.equals(this.getList()) || !activeWindow.equals(window);
    }

    protected Window windowForComponent(Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        Container parent = aComponent.getParent();
        Window window = null;
        boolean found = false;
        while (parent != null && !found) {
            if (parent instanceof Window) {
                window = (Window)parent;
                found = true;
                continue;
            }
            parent = parent.getParent();
        }
        return window;
    }

    protected JList getList() {
        return this.list;
    }

    protected boolean hasCellFocus() {
        return this.cellHasFocus;
    }
}

