/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.packager.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.jdesktop.jdic.packager.impl.WinMsiWrapper;
import org.jdesktop.jdic.packager.impl.WinUtility;

public class WinMsiUtility {
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FAIL = -1;
    private static final int LICENSED_WELCOME_MSG_FIELD_INDEX = 2;
    private static final int NON_LICENSED_WELCOME_MSG_FIELD_INDEX = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSummaryInfoProperty(String string, int n, String string2) throws IOException {
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = WinMsiUtility.openDatabase(string);
            n3 = WinMsiUtility.openSummaryInfo(n2);
            WinMsiWrapper.winMsiSummaryInfoSetProperty(n3, n, string2);
            WinMsiWrapper.winMsiSummaryInfoPersist(n3);
            WinMsiWrapper.winMsiDatabaseCommit(n2);
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n3);
            WinMsiWrapper.winMsiCloseHandle(n2);
            WinMsiWrapper.winMsiCloseAllHandles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void winMsiSetProperty(String string, String string2, String string3, int n, boolean bl, TreeMap treeMap) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("MSI table name can't be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("MSI key field name can't be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("MSI value index can't be null");
        }
        if (treeMap == null) {
            throw new IllegalArgumentException("map data can't be null!");
        }
        if (treeMap.size() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        try {
            n2 = WinMsiUtility.openDatabase(string);
            Iterator iterator = treeMap.keySet().iterator();
            String string4 = null;
            String string5 = null;
            while (iterator.hasNext()) {
                String string6;
                String string7;
                string4 = (String)iterator.next();
                string5 = (String)treeMap.get(string4);
                if (bl) {
                    WinUtility.checkFileValid(string5);
                }
                if ((n4 = WinMsiUtility.getRecord(n3 = WinMsiUtility.openView(n2, string2, string7 = "*", string6 = " where " + string3 + " = '" + string4 + "'"))) == 0) continue;
                WinMsiUtility.setRecordProperty(n3, n4, n, bl, string5);
                bl2 = true;
            }
            if (bl2) {
                WinMsiWrapper.winMsiDatabaseCommit(n2);
            }
        }
        finally {
            WinMsiUtility.closeView(n3);
            WinMsiWrapper.winMsiCloseHandle(n2);
            WinMsiWrapper.winMsiCloseAllHandles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTransform(String string, String string2, String string3) throws IOException {
        int n = 0;
        int n2 = 0;
        try {
            n = WinMsiUtility.openDatabase(string);
            n2 = WinMsiUtility.openDatabase(string2);
            WinMsiWrapper.winMsiDatabaseGenerateTransform(n, n2, string3);
            WinMsiWrapper.winMsiCreateTransformSummaryInfo(n, n2, string3);
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n);
            WinMsiWrapper.winMsiCloseHandle(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSql(String string, ArrayList arrayList) throws IOException {
        int n = 0;
        int n2 = 0;
        try {
            n = WinMsiUtility.openDatabase(string);
            int[] nArray = new int[]{0, 0};
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                nArray = WinMsiWrapper.winMsiDatabaseOpenView(n, string2);
                n2 = nArray[1];
                WinMsiWrapper.winMsiViewExecute(n2, 0);
            }
            WinMsiWrapper.winMsiDatabaseCommit(n);
        }
        finally {
            WinMsiUtility.closeView(n2);
            WinMsiWrapper.winMsiCloseHandle(n);
            WinMsiWrapper.winMsiCloseAllHandles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBinaryRecord(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            int n4;
            n = WinMsiUtility.openDatabase(string);
            String string3 = stringArray[0];
            for (n4 = 1; n4 < stringArray.length; ++n4) {
                string3 = string3 + ", " + stringArray[n4];
            }
            n2 = WinMsiUtility.openView(n, string2, string3, "");
            n3 = WinMsiWrapper.winMsiCreateRecord(stringArray.length);
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (stringArray2[n4].compareToIgnoreCase("String") == 0) {
                    WinMsiWrapper.winMsiRecordSetString(n3, n4 + 1, stringArray3[n4]);
                    WinMsiWrapper.winMsiViewExecute(n2, n3);
                }
                if (stringArray2[n4].compareToIgnoreCase("Stream") != 0) continue;
                WinMsiWrapper.winMsiRecordSetStream(n3, n4 + 1, stringArray3[n4]);
                WinMsiWrapper.winMsiViewModify(n2, 3, n3);
            }
            WinMsiWrapper.winMsiDatabaseCommit(n);
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n3);
            WinMsiUtility.closeView(n2);
            WinMsiWrapper.winMsiCloseHandle(n);
        }
    }

    public static void incorporateMST(String string, String string2, String string3) throws IOException {
        String[] stringArray = new String[]{"Name", "Data"};
        String string4 = "_Storages";
        String[] stringArray2 = new String[]{"String", "Stream"};
        String[] stringArray3 = new String[]{string3, string2};
        WinMsiUtility.addBinaryRecord(string, string4, stringArray, stringArray2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importTableFromFile(String string, String string2, String string3) throws IOException {
        int n = 0;
        try {
            n = WinMsiUtility.openDatabase(string);
            WinMsiWrapper.winMsiDatabaseImport(n, string2, string3);
            WinMsiWrapper.winMsiDatabaseCommit(n);
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n);
        }
    }

    public static void applyMstToMsi(String string, String string2) throws IOException {
        int[] nArray = new int[]{0, 0};
        try {
            nArray = WinMsiWrapper.winMsiOpenDatabase(string, 1);
            int n = nArray[1];
            WinMsiWrapper.winMsiDatabaseApplyTransform(n, string2);
            WinMsiWrapper.winMsiDatabaseCommit(n);
            WinMsiWrapper.winMsiCloseHandle(n);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRecordProperty(int n, int n2, int n3, boolean bl, String string) throws IOException {
        try {
            if (bl) {
                WinMsiWrapper.winMsiRecordSetStream(n2, n3, string);
            } else {
                WinMsiWrapper.winMsiRecordSetString(n2, n3, string);
            }
            WinMsiWrapper.winMsiViewModify(n, 4, n2);
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n2);
        }
    }

    private static int openDatabase(String string) throws IOException {
        int[] nArray = new int[]{-1, 0};
        nArray = WinMsiWrapper.winMsiOpenDatabase(string, 1);
        return nArray[1];
    }

    private static int openSummaryInfo(int n) throws IOException {
        int[] nArray = new int[]{-1, 0};
        nArray = WinMsiWrapper.winMsiGetSummaryInformation(n);
        return nArray[1];
    }

    private static int openView(int n, String string, String string2, String string3) throws IOException {
        int[] nArray = new int[]{-1, 0};
        String string4 = "select " + string2 + " from " + string + " " + string3;
        nArray = WinMsiWrapper.winMsiDatabaseOpenView(n, string4);
        int n2 = nArray[1];
        WinMsiWrapper.winMsiViewExecute(n2, 0);
        return n2;
    }

    private static void closeView(int n) throws IOException {
        WinMsiWrapper.winMsiViewClose(n);
        WinMsiWrapper.winMsiCloseHandle(n);
    }

    private static int getRecord(int n) throws IOException {
        int[] nArray = WinMsiWrapper.winMsiViewFetch(n);
        if (nArray[0] == 259) {
            return 0;
        }
        return nArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWelcomeMsg(String string, String string2, boolean bl) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = WinMsiUtility.openDatabase(string);
            String string3 = "WelcomeMsg";
            String string4 = "*";
            String string5 = " where Locale = '" + string2 + "'";
            n2 = WinMsiUtility.openView(n, string3, string4, string5);
            n3 = WinMsiUtility.getRecord(n2);
            String string6 = null;
            string6 = bl ? WinMsiWrapper.winMsiRecordGetString(n3, 2) : WinMsiWrapper.winMsiRecordGetString(n3, 3);
            String string7 = string6;
            return string7;
        }
        finally {
            WinMsiWrapper.winMsiCloseHandle(n3);
            WinMsiUtility.closeView(n2);
            WinMsiWrapper.winMsiCloseHandle(n);
        }
    }

    public static String genUUID() throws IOException {
        String string = WinMsiWrapper.generateUUID();
        if (string != null) {
            return string.toUpperCase();
        }
        throw new IOException("Could not generate the UUID.");
    }
}

