/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import javax.swing.AbstractListModel;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageListType;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;

public class PassageListModel
extends AbstractListModel
implements PassageListener {
    private Passage ref;
    private int size;
    private PassageListType mode;
    private RestrictionType restrict;
    private static final long serialVersionUID = 3761692273179964725L;

    public PassageListModel() {
        this(null, PassageListType.VERSES, RestrictionType.NONE);
    }

    public PassageListModel(Passage ref) {
        this(ref, PassageListType.VERSES, RestrictionType.NONE);
    }

    public PassageListModel(Passage ref, PassageListType mode, RestrictionType restrict) {
        this.ref = ref;
        this.restrict = restrict;
        this.setMode(mode);
        this.setPassage(ref);
    }

    public final void setMode(PassageListType mode) {
        this.mode = mode;
    }

    public PassageListType getMode() {
        return this.mode;
    }

    public void setRestriction(RestrictionType restrict) {
        this.restrict = restrict;
    }

    public RestrictionType getRestriction() {
        return this.restrict;
    }

    public int getSize() {
        return this.size;
    }

    private void recomputeSize() {
        this.size = this.mode.count(this.ref, this.restrict);
    }

    public Object getElementAt(int index) {
        return this.mode.getElementAt(this.ref, index, this.restrict);
    }

    public void versesAdded(PassageEvent ev) {
        this.recomputeSize();
        this.fireIntervalRemoved(this, 0, this.size);
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public void versesRemoved(PassageEvent ev) {
        this.recomputeSize();
        this.fireIntervalRemoved(this, 0, this.size);
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public void versesChanged(PassageEvent ev) {
        this.recomputeSize();
        this.fireIntervalRemoved(this, 0, this.size);
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public final void setPassage(Passage newRef) {
        this.fireIntervalRemoved(this, 0, this.size);
        if (this.ref != null) {
            this.ref.removePassageListener((PassageListener)this);
        }
        this.ref = newRef;
        if (this.ref != null) {
            this.ref.optimizeReads();
            this.ref.addPassageListener((PassageListener)this);
        }
        this.recomputeSize();
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public Passage getPassage() {
        return this.ref;
    }
}

