/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Iterator;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.passage.BibleTreeNode;
import org.crosswire.bibledesktop.passage.ChapterTreeNode;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.Verse;

public class BookTreeNode
extends BibleTreeNode {
    protected int book;
    protected TreeNode parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BookTreeNode(TreeNode parent, int book) throws NoSuchVerseException {
        this.parent = parent;
        this.book = book;
        this.kids = new ChapterTreeNode[BibleInfo.chaptersInBook((int)book)];
    }

    public void setPassage(Passage ref, boolean filter) {
        block4: {
            this.ref = ref;
            if (filter) {
                try {
                    this.kids = new ChapterTreeNode[ref.chaptersInPassage(this.book)];
                    int currentRef = 0;
                    int count = 0;
                    Iterator it = ref.iterator();
                    while (it.hasNext()) {
                        Verse verse = (Verse)it.next();
                        if (this.book != 0 && verse.getBook() != this.book || currentRef == verse.getChapter()) continue;
                        currentRef = verse.getChapter();
                        ChapterTreeNode node = new ChapterTreeNode(this, this.book, currentRef);
                        node.setPassage(ref, true);
                        this.kids[count++] = node;
                    }
                }
                catch (NoSuchVerseException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    public TreeNode getChildAt(int i) {
        try {
            if (this.kids[i] != null) {
                return this.kids[i];
            }
            ChapterTreeNode node = new ChapterTreeNode(this, this.book, i + 1);
            node.setPassage(this.ref, false);
            this.kids[i] = node;
            return this.kids[i];
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        if (!(node instanceof ChapterTreeNode)) {
            return -1;
        }
        ChapterTreeNode chap = (ChapterTreeNode)node;
        return chap.getChapter();
    }

    public String toString() {
        try {
            String bookName = BibleInfo.getLongBookName((int)this.book);
            if (this.ref == null) {
                return bookName;
            }
            int chapters = this.ref.chaptersInPassage(this.book);
            if (chapters == 0) {
                return bookName;
            }
            return bookName + " (" + chapters + ')';
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public int getBook() {
        return this.book;
    }

    static {
        $assertionsDisabled = !BookTreeNode.class.desiredAssertionStatus();
    }
}

