/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.SAXEventProviderInputSource;
import org.crosswire.common.xml.SAXEventProviderXMLReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TransformingSAXEventProvider
implements SAXEventProvider {
    private ErrorListener errors;
    private URIResolver resolver;
    private Properties outputs = new Properties();
    private Map params = new HashMap();
    private URL xslurl;
    private SAXEventProvider xmlsep;
    private TransformerFactory transfact = TransformerFactory.newInstance();
    private static Map txers = new HashMap();
    private static final Logger log = Logger.getLogger(TransformingSAXEventProvider.class);

    public TransformingSAXEventProvider(URL xslurl, SAXEventProvider xmlsep) {
        this.xslurl = xslurl;
        this.xmlsep = xmlsep;
    }

    private TemplateInfo getTemplateInfo() throws IOException, TransformerConfigurationException {
        long modtime = NetUtil.getLastModified(this.xslurl);
        TemplateInfo tinfo = (TemplateInfo)txers.get(this.xslurl);
        if (tinfo != null && modtime > tinfo.getModtime()) {
            txers.remove(this.xslurl);
            tinfo = null;
            log.debug("updated style, re-caching. xsl=" + this.xslurl.toExternalForm());
        }
        if (tinfo == null) {
            log.debug("generating templates for " + this.xslurl.toExternalForm());
            InputStream xsl_in = this.xslurl.openStream();
            Templates templates = this.transfact.newTemplates(new StreamSource(xsl_in));
            tinfo = new TemplateInfo(templates, modtime);
            txers.put(this.xslurl, tinfo);
        }
        return tinfo;
    }

    public void provideSAXEvents(ContentHandler handler) throws SAXException {
        try {
            String val;
            String key;
            SAXSource src_in = new SAXSource(new SAXEventProviderXMLReader(this.xmlsep), new SAXEventProviderInputSource());
            TemplateInfo tinfo = this.getTemplateInfo();
            SAXResult res_out = new SAXResult(handler);
            Transformer transformer = tinfo.getTemplates().newTransformer();
            Iterator<Object> it = this.outputs.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                val = this.getOutputProperty(key);
                transformer.setOutputProperty(key, val);
            }
            it = this.params.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                val = this.params.get(key);
                transformer.setParameter(key, val);
            }
            if (this.errors != null) {
                transformer.setErrorListener(this.errors);
            }
            if (this.resolver != null) {
                transformer.setURIResolver(this.resolver);
            }
            transformer.transform(src_in, res_out);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerException ex) {
            throw new SAXException(ex);
        }
    }

    public ErrorListener getErrorListener() {
        return this.errors;
    }

    public void setErrorListener(ErrorListener errors) throws IllegalArgumentException {
        this.errors = errors;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.resolver = resolver;
    }

    public Properties getOutputProperties() {
        return this.outputs;
    }

    public void setOutputProperties(Properties outputs) throws IllegalArgumentException {
        this.outputs = outputs;
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        return this.outputs.getProperty(name);
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        this.outputs.setProperty(name, value);
    }

    public void clearParameters() {
        this.params.clear();
    }

    public Object getParameter(String name) {
        return this.params.get(name);
    }

    public void setParameter(String name, Object value) {
        this.params.put(name, value);
    }

    private static class TemplateInfo {
        private Templates templates;
        private long modtime;

        public TemplateInfo(Templates templates, long modtime) {
            this.templates = templates;
            this.modtime = modtime;
        }

        Templates getTemplates() {
            return this.templates;
        }

        long getModtime() {
            return this.modtime;
        }
    }
}

