/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.crosswire.common.swing.RowColumns;
import org.crosswire.common.swing.RowTableModel;
import org.crosswire.common.swing.SortRenderer;

public class RowTable
extends JTable {
    private static final long serialVersionUID = 3761407508275081783L;
    private static final String ONE_STANDARD_CHARACTER = "M";
    private static final String TWO_STANDARD_CHARACTERS = "MM";
    private static final int PADDING = 3;

    public RowTable(List aList, RowColumns columns) {
        super(new RowTableModel(aList, columns));
        this.setSortRenderer();
        this.setColumnWidths(columns.getCharacterWidths(), columns.getFixedWidths());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                RowTable.this.sort(RowTable.this.getColumnModel().getColumnIndexAtX(e.getX()));
            }
        });
    }

    private List saveSelection(JTable aTable) {
        ListSelectionModel lsm = aTable.getSelectionModel();
        RowTableModel tm = (RowTableModel)aTable.getModel();
        int first = lsm.getMinSelectionIndex();
        int last = lsm.getMaxSelectionIndex();
        ArrayList<Object> objs = new ArrayList<Object>();
        if (first != -1) {
            for (int i = first; i <= last; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                objs.add(tm.getRow(i));
            }
        }
        return objs;
    }

    private void loadSelection(JTable aTable, List objs) {
        ListSelectionModel lsm = aTable.getSelectionModel();
        RowTableModel tm = (RowTableModel)aTable.getModel();
        for (int i = 0; i < objs.size(); ++i) {
            Object obj = objs.get(i);
            int where = tm.getRow(obj);
            if (where == -1) continue;
            lsm.addSelectionInterval(where, where);
        }
        this.scrollToVisible(aTable);
    }

    private void scrollToVisible(JTable aTable) {
        Rectangle bounds;
        ListSelectionModel lsm = aTable.getSelectionModel();
        int first = lsm.getMinSelectionIndex();
        int last = lsm.getMaxSelectionIndex();
        if (first != -1 && !this.isVerticallyVisible(aTable, bounds = this.getRowBounds(aTable, first, last))) {
            aTable.scrollRectToVisible(bounds);
        }
    }

    public void selectRow(int row) {
        ListSelectionModel lsm = this.getSelectionModel();
        lsm.clearSelection();
        lsm.setSelectionInterval(row, row);
        this.scrollToVisible(this);
    }

    private Rectangle getRowBounds(JTable table, int first, int last) {
        Rectangle result = table.getCellRect(first, -1, true);
        result = result.union(table.getCellRect(last, -1, true));
        Insets insets = table.getInsets();
        result.x = insets.left;
        result.width = table.getWidth() - insets.left - insets.right;
        return result;
    }

    private boolean isVerticallyVisible(JTable aTable, Rectangle r) {
        Rectangle visible = aTable.getVisibleRect();
        return visible.y <= r.y && visible.y + visible.height >= r.y + r.height;
    }

    private void setColumnWidths(int[] widths, boolean[] fixed) {
        int mWidth = this.getStandardCharacterWidth();
        TableColumnModel tcm = this.getColumnModel();
        int margins = (tcm.getColumnMargin() << 1) + 3;
        for (int i = 0; i < widths.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            int width = widths[i] * mWidth + margins;
            if (fixed[i]) {
                tc.setMinWidth(width);
                tc.setMaxWidth(width);
                continue;
            }
            tc.setPreferredWidth(width);
        }
    }

    private void setSortRenderer() {
        SortRenderer sortRenderer = new SortRenderer((RowTableModel)this.getModel());
        TableColumnModel model = this.getColumnModel();
        int colCount = model.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            TableColumn tc = model.getColumn(i);
            tc.setHeaderRenderer(sortRenderer);
        }
    }

    private int getStandardCharacterWidth() {
        JTableHeader th = this.getTableHeader();
        TableCellRenderer renderer = th.getDefaultRenderer();
        Component comp = renderer.getTableCellRendererComponent(this, ONE_STANDARD_CHARACTER, false, false, 0, 0);
        int oneStandardCharacterWidth = comp.getPreferredSize().width;
        comp = renderer.getTableCellRendererComponent(this, TWO_STANDARD_CHARACTERS, false, false, 0, 0);
        int twoStandardCharactersWidth = comp.getPreferredSize().width;
        return twoStandardCharactersWidth - oneStandardCharacterWidth;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public int getPreferredHeight(int numRows) {
        int newHeight = this.getRowHeight() * numRows;
        newHeight += this.getTableHeader().getPreferredSize().height;
        Insets insets = this.getInsets();
        return newHeight += insets.top + insets.bottom;
    }

    public void sort(int col) {
        if (col != -1) {
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            SortRenderer renderer = (SortRenderer)tc.getHeaderRenderer();
            renderer.setPressedColumn(tc);
        }
        List objs = this.saveSelection(this);
        this.getSelectionModel().clearSelection();
        ((RowTableModel)this.getModel()).sort(this.convertColumnIndexToModel(col));
        this.loadSelection(this, objs);
    }

    public void reset() {
        RowTableModel stm = (RowTableModel)this.getModel();
        ListSelectionModel lsm = this.getSelectionModel();
        this.getSelectionModel().clearSelection();
        lsm.clearSelection();
        stm.reset();
    }
}

