/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.util.Map;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.MultipleChoice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.OptionsField;
import org.crosswire.common.config.swing.TextField;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Reporter;

public class FieldMap {
    private static Map map = ClassUtil.getImplementorsMap(Field.class);
    private static final Logger log = Logger.getLogger(FieldMap.class);

    private FieldMap() {
    }

    public static Field getField(Choice type) {
        Field field;
        block6: {
            field = null;
            try {
                if (type instanceof MultipleChoice) {
                    field = new OptionsField();
                } else {
                    Class clazz = (Class)map.get(type.getType());
                    if (clazz != null) {
                        field = (Field)clazz.newInstance();
                    } else {
                        log.warn("field type (" + type + ") unregistered.");
                        field = new TextField();
                    }
                }
            }
            catch (Exception ex) {
                log.warn("field type (" + type + ") initialization failed:", ex);
                Reporter.informUser((Object)type, ex);
                if (field != null) break block6;
                log.warn("field type (" + type + ") unregistered.");
                field = new TextField();
            }
        }
        field.setChoice(type);
        return field;
    }
}

