/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.activate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.activate.Msg;

public class Activator {
    public static final int KILL_EVERYTHING = 0;
    public static final int KILL_LEAST_USED = 1;
    public static final int KILL_ONLY_IF_TIGHT = 2;
    private static Set activated = new HashSet();
    private static Lock lock = new Lock();

    private Activator() {
    }

    public static void activate(Activatable subject) {
        if (!activated.contains(subject) && subject != null) {
            subject.activate(lock);
            activated.add(subject);
        }
    }

    public static void reduceMemoryUsage(int amount) {
        switch (amount) {
            case 0: {
                Iterator it = activated.iterator();
                while (it.hasNext()) {
                    Activatable subject = (Activatable)it.next();
                    Activator.deactivate(subject);
                }
                break;
            }
            case 1: {
                throw new IllegalArgumentException(Msg.NOT_IMPLEMENTED.toString());
            }
            case 2: {
                throw new IllegalArgumentException(Msg.NOT_IMPLEMENTED.toString());
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void deactivate(Activatable subject) {
        if (activated.contains(subject) && subject != null) {
            subject.deactivate(lock);
            activated.remove(subject);
        }
    }
}

