/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;

public class BeanPanel
extends JPanel {
    protected Object bean;
    private List editors = new ArrayList();
    protected static final Logger log = Logger.getLogger(BeanPanel.class);
    private static final long serialVersionUID = 3834589894202175795L;

    public BeanPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
    }

    public void setBean(Object abean) throws IntrospectionException {
        this.bean = abean;
        this.removeAll();
        this.editors.clear();
        int y = 0;
        if (this.bean != null) {
            BeanInfo info = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor property = properties[i];
                if (property.isHidden() || property.getWriteMethod() == null) continue;
                JLabel label = new JLabel();
                JTextField text = new JTextField();
                String title = property.getDisplayName();
                title = StringUtil.createTitle(title);
                label.setText(title + ":");
                label.setLabelFor(text);
                Method writer = property.getWriteMethod();
                text.getDocument().addDocumentListener(new CustomDocumentListener(text, writer));
                try {
                    Method reader = property.getReadMethod();
                    Object reply = reader.invoke(this.bean, null);
                    if (reply == null) {
                        text.setText("");
                    } else {
                        text.setText(reply.toString());
                    }
                }
                catch (Exception ex) {
                    text.setText(Msg.ERROR_READING.toString(ex.getMessage()));
                    log.warn("property read failed", ex);
                }
                this.editors.add(text);
                this.add((Component)label, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 2, 2), 0, 0));
                this.add((Component)text, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
                ++y;
            }
        }
        this.invalidate();
        this.repaint();
    }

    public Object getBean() {
        return this.bean;
    }

    public void setEditable(boolean editable) {
        Iterator it = this.editors.iterator();
        while (it.hasNext()) {
            JTextField text = (JTextField)it.next();
            text.setEditable(editable);
        }
    }

    private final class CustomDocumentListener
    implements DocumentListener {
        private final JTextField text;
        private final Method writer;

        protected CustomDocumentListener(JTextField text, Method writer) {
            this.text = text;
            this.writer = writer;
        }

        public void changedUpdate(DocumentEvent ev) {
            try {
                String data = this.text.getText();
                this.writer.invoke(BeanPanel.this.bean, data);
            }
            catch (Exception ex) {
                log.error("Introspected set failed", ex);
            }
        }

        public void insertUpdate(DocumentEvent ev) {
            this.changedUpdate(ev);
        }

        public void removeUpdate(DocumentEvent ev) {
            this.changedUpdate(ev);
        }
    }
}

