/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.crosswire.common.progress.Job;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;

public class HttpSwordInstaller
extends AbstractSwordInstaller
implements Comparable {
    private static final String PROTOCOL_WEB = "sword-http";

    public String getURL() {
        return "sword-http://" + this.host + this.directory;
    }

    public URL toRemoteURL(Book book) {
        try {
            return new URL("http", this.host, this.directory + '/' + "packages/rawzip" + '/' + book.getInitials() + ".zip");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    protected void download(Job job, String dir, String file, URL dest) throws InstallException {
        try {
            URL url = new URL("http", this.host, dir + '/' + file);
            this.copy(job, url, dest);
        }
        catch (IOException ex) {
            throw new InstallException((MsgBase)Msg.UNKNOWN_ERROR, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Job job, URL url, URL dest) throws IOException, InstallException {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (job != null) {
                job.setProgress(Msg.JOB_DOWNLOADING.toString());
            }
            out = NetUtil.getOutputStream((URL)dest);
            URLConnection urlConnection = url.openConnection();
            try {
                in = urlConnection.getInputStream();
            }
            catch (Exception exception) {
                throw new InstallException((MsgBase)Msg.MISSING_FILE, exception);
            }
            byte[] buf = new byte[4096];
            int count = 0;
            while (-1 != (count = in.read(buf))) {
                out.write(buf, 0, count);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close((OutputStream)out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpSwordInstaller)) {
            return false;
        }
        HttpSwordInstaller that = (HttpSwordInstaller)object;
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

