/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.filter.gbf.BoldTagBuilder;
import org.crosswire.jsword.book.filter.gbf.CrossRefTagBuilder;
import org.crosswire.jsword.book.filter.gbf.EndOfLineTagBuilder;
import org.crosswire.jsword.book.filter.gbf.FootnoteTagBuilder;
import org.crosswire.jsword.book.filter.gbf.HeaderTagBuilder;
import org.crosswire.jsword.book.filter.gbf.IgnoredTagBuilder;
import org.crosswire.jsword.book.filter.gbf.ItalicTagBuilder;
import org.crosswire.jsword.book.filter.gbf.JustifyTagBuilder;
import org.crosswire.jsword.book.filter.gbf.OTQuoteTagBuilder;
import org.crosswire.jsword.book.filter.gbf.ParagraphTagBuilder;
import org.crosswire.jsword.book.filter.gbf.PoetryTagBuilder;
import org.crosswire.jsword.book.filter.gbf.PsalmTitleTagBuilder;
import org.crosswire.jsword.book.filter.gbf.RedLetterTagBuilder;
import org.crosswire.jsword.book.filter.gbf.StrongsMorphTagBuilder;
import org.crosswire.jsword.book.filter.gbf.StrongsWordTagBuilder;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.book.filter.gbf.TagBuilder;
import org.crosswire.jsword.book.filter.gbf.TextFootnoteTagBuilder;
import org.crosswire.jsword.book.filter.gbf.TextTagBuilder;
import org.crosswire.jsword.book.filter.gbf.TitleTagBuilder;
import org.crosswire.jsword.book.filter.gbf.UnderlineTagBuilder;
import org.crosswire.jsword.passage.Key;
import org.jdom.Element;

public class GBFFilter
implements Filter {
    protected static final Logger log = Logger.getLogger((Class)GBFFilter.class);
    private static final String SEPARATORS = " ,:;.?!";
    private static final TagBuilder TEXT = new TextTagBuilder();
    private static final TagBuilder[] BUILDERS = new TagBuilder[]{new BoldTagBuilder(), new CrossRefTagBuilder(), new EndOfLineTagBuilder(), new FootnoteTagBuilder(), new HeaderTagBuilder(), new IgnoredTagBuilder(), new ItalicTagBuilder(), new JustifyTagBuilder(), new OTQuoteTagBuilder(), new ParagraphTagBuilder(), new PoetryTagBuilder(), new PsalmTitleTagBuilder(), new RedLetterTagBuilder(), new StrongsMorphTagBuilder(), new StrongsWordTagBuilder(), new TitleTagBuilder(), new TextFootnoteTagBuilder(), new UnderlineTagBuilder()};

    public List toOSIS(Key key, String plain) throws FilterException {
        DataPolice.setKey(key);
        Element ele = OSISUtil.factory().createDiv();
        LinkedList<Element> stack = new LinkedList<Element>();
        stack.addFirst(ele);
        List taglist = this.parseTags(plain.trim());
        while (!taglist.isEmpty()) {
            Tag tag = (Tag)taglist.remove(0);
            tag.updateOsisStack(stack);
        }
        stack.removeFirst();
        DataPolice.setKey(null);
        return ele.removeContent();
    }

    private List parseTags(String remains) {
        ArrayList<Tag> taglist = new ArrayList<Tag>();
        while (true) {
            String tag;
            int i;
            int ltpos = remains.indexOf(60);
            int gtpos = remains.indexOf(62);
            if (ltpos == -1 && gtpos == -1) {
                taglist.add(GBFFilter.createText(remains));
                remains = null;
                break;
            }
            if (ltpos == -1 || gtpos == -1) {
                DataPolice.report("ignoring unmatched '<' or '>' in gbf: " + remains);
                taglist.add(GBFFilter.createText(remains));
                remains = null;
                break;
            }
            if (ltpos > gtpos) {
                DataPolice.report("ignoring transposed '<' or '>' in gbf: " + remains);
                taglist.add(GBFFilter.createText(remains));
                remains = null;
                break;
            }
            String start = remains.substring(0, ltpos);
            int strLen = start.length();
            if (strLen > 0) {
                int beginIndex = 0;
                boolean inSepStr = SEPARATORS.indexOf(start.charAt(0)) >= 0;
                for (i = 1; inSepStr && i < strLen; ++i) {
                    char currentChar = start.charAt(i);
                    if (SEPARATORS.indexOf(currentChar) >= 0) continue;
                    taglist.add(GBFFilter.createText(start.substring(beginIndex, i)));
                    beginIndex = i;
                    inSepStr = false;
                }
                if (beginIndex < strLen) {
                    taglist.add(GBFFilter.createText(start.substring(beginIndex)));
                }
            }
            if ((tag = remains.substring(ltpos + 1, gtpos)).length() > 0) {
                Tag reply = null;
                for (i = 0; i < BUILDERS.length && (reply = BUILDERS[i].createTag(tag)) == null; ++i) {
                }
                if (reply == null) {
                    log.warn("Ignoring tag of <" + tag + ">");
                } else {
                    taglist.add(reply);
                }
            }
            remains = remains.substring(gtpos + 1);
        }
        return taglist;
    }

    private static Tag createText(String text) {
        return TEXT.createTag(text);
    }
}

