/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.LinkedList;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.book.filter.gbf.TagBuilder;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.jdom.Content;
import org.jdom.Element;

public class CrossRefTagBuilder
implements TagBuilder {
    protected KeyFactory keyf = PassageKeyFactory.instance();

    public Tag createTag(final String name) {
        if (name.startsWith("RX")) {
            return new Tag(){

                public void updateOsisStack(LinkedList stack) {
                    Element seg = OSISUtil.factory().createReference();
                    String refstr = name.substring(2);
                    try {
                        Passage ref = (Passage)CrossRefTagBuilder.this.keyf.getKey(refstr);
                        seg.setAttribute("osisRef", ref.getOSISName());
                    }
                    catch (NoSuchKeyException ex) {
                        DataPolice.report("unable to parse reference: " + refstr);
                    }
                    Element current = (Element)stack.get(0);
                    current.addContent((Content)seg);
                    stack.addFirst(seg);
                }
            };
        }
        if (name.startsWith("Rx")) {
            return new Tag(){

                public void updateOsisStack(LinkedList stack) {
                    stack.removeFirst();
                }
            };
        }
        return null;
    }
}

