/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.BookDataDisplayFactory;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.bibledesktop.passage.KeyListListModel;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookType;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PreferredKey;
import org.crosswire.jsword.passage.Verse;

public class DictionaryPane
extends JPanel
implements BookDataDisplay {
    private BookDataDisplay display = BookDataDisplayFactory.createBookDataDisplay();
    private BookFilter filter = BookFilters.either((BookFilter)BookFilters.getDictionaries(), (BookFilter)BookFilters.getCommentaries());
    private BooksComboBoxModel mdlDicts = new BooksComboBoxModel(this.filter);
    private Book dict;
    protected BibleComboBoxModelSet set = new BibleComboBoxModelSet();
    private JComboBox cboBooks = new JComboBox();
    private JComboBox cboChaps = new JComboBox();
    private JComboBox cboVerse = new JComboBox();
    private JPanel pnlSelect = new JPanel();
    private JScrollPane scrDicts = new JScrollPane();
    private JList lstDicts = new JList();
    private JSplitPane sptMain = new FixedSplitPane();
    private JScrollPane scrEntries = new JScrollPane();
    private JScrollPane scrDisplay = new JScrollPane();
    private JList lstEntries = new JList();
    private static final Logger log = Logger.getLogger((Class)DictionaryPane.class);
    private static final long serialVersionUID = 3616449020667442997L;

    public DictionaryPane() {
        this.init();
        this.lstDicts.setSelectedValue(Defaults.getDictionary(), true);
    }

    private void init() {
        this.lstDicts.setVisibleRowCount(6);
        this.lstDicts.setSelectionMode(0);
        this.lstDicts.setModel(this.mdlDicts);
        this.lstDicts.setCellRenderer(new BookListCellRenderer());
        this.lstDicts.setPrototypeCellValue("012345678901234567890123456789");
        this.lstDicts.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                DictionaryPane.this.newDictionary();
            }
        });
        this.scrDicts.setViewportView(this.lstDicts);
        this.set.setBookComboBox(this.cboBooks);
        this.set.setChapterComboBox(this.cboChaps);
        this.set.setVerseComboBox(this.cboVerse);
        this.set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DictionaryPane.this.updateDisplay();
            }
        });
        this.cboBooks.setToolTipText(Msg.SELECT_BOOK.toString());
        this.cboChaps.setToolTipText(Msg.SELECT_CHAPTER.toString());
        this.cboVerse.setToolTipText(Msg.SELECT_VERSE.toString());
        this.pnlSelect.setLayout(new FlowLayout());
        this.pnlSelect.add((Component)this.cboBooks, null);
        this.pnlSelect.add((Component)this.cboChaps, null);
        this.pnlSelect.add((Component)this.cboVerse, null);
        this.lstEntries.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                DictionaryPane.this.newEntry();
            }
        });
        this.scrEntries.setViewportView(this.lstEntries);
        this.scrDisplay.setViewportView(this.display.getComponent());
        this.sptMain.setOrientation(0);
        this.sptMain.setResizeWeight(0.2);
        this.sptMain.setTopComponent(new JPanel());
        this.sptMain.setBottomComponent(this.scrDisplay);
        this.sptMain.setBorder(null);
        this.sptMain.setDividerSize(8);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.scrDicts, "North");
        this.add((Component)this.sptMain, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void setBookData(Book book, Key key) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        this.display.refresh();
    }

    public Component getComponent() {
        return this;
    }

    public void copy() {
        this.display.copy();
    }

    public Key getKey() {
        return (Key)this.lstEntries.getSelectedValue();
    }

    public void addURLEventListener(URLEventListener listener) {
        this.display.addURLEventListener(listener);
    }

    public void removeURLEventListener(URLEventListener listener) {
        this.display.removeURLEventListener(listener);
    }

    public Book getBook() {
        return this.dict;
    }

    public void setWord(String data) {
        try {
            if (this.dict == null) {
                return;
            }
            Key key = this.dict.getKey(data);
            if (key != null) {
                this.lstEntries.setSelectedValue(key, true);
            }
        }
        catch (NoSuchKeyException noSuchKeyException) {
            // empty catch block
        }
    }

    public void setKey(Key key) {
        Passage ref;
        if (key != null && key instanceof Passage && (ref = (Passage)key).countVerses() > 0) {
            this.set.setVerse(ref.getVerseAt(0));
        }
        this.updateDisplay();
    }

    public void selectDictionary(Book book) {
        this.lstDicts.setSelectedValue(book, true);
    }

    protected void newDictionary() {
        Object selected = this.lstDicts.getSelectedValue();
        if (selected != null) {
            Book book = (Book)selected;
            if (book.getType().equals((Object)BookType.DICTIONARY)) {
                this.dict = book;
                Key key = this.dict.getGlobalKeyList();
                KeyListListModel model = new KeyListListModel(key);
                this.lstEntries.setModel(model);
                if (this.dict instanceof PreferredKey) {
                    PreferredKey pref = (PreferredKey)this.dict;
                    Key prefkey = pref.getPreferred();
                    this.lstEntries.setSelectedValue(prefkey, true);
                }
                this.sptMain.setTopComponent(this.scrEntries);
            } else {
                this.sptMain.setTopComponent(this.pnlSelect);
            }
        }
    }

    protected void updateDisplay() {
        Book book = (Book)this.lstDicts.getSelectedValue();
        if (book == null) {
            log.warn("no selected dictionary");
            return;
        }
        try {
            Verse verse = this.set.getVerse();
            this.display.setBookData(book, (Key)verse);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    protected void newEntry() {
        try {
            Key key = (Key)this.lstEntries.getSelectedValue();
            if (key != null) {
                this.display.setBookData(this.dict, key);
            }
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }
}

