/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.NumberCellRenderer;
import org.crosswire.common.swing.UserMsg;

public class FontChooser
extends JPanel {
    public static final String PROPERTY_STYLE = "style";
    protected static final JLabel DEFAULT_FONT = new JLabel();
    protected JDialog dialog;
    protected Font font;
    private static final int MIN_FONT_SIZE = 5;
    private static final int MAX_FONT_SIZE = 72;
    private static final int RENDERED_FONT_SIZE = 16;
    protected JComboBox name = new JComboBox();
    protected JCheckBox bold = new JCheckBox(UserMsg.BOLD.toString());
    protected JCheckBox italic = new JCheckBox(UserMsg.ITALIC.toString());
    protected JComboBox size = new JComboBox();
    protected boolean suppressEvents;
    private static final long serialVersionUID = 3978992071925250097L;

    public FontChooser() {
        ItemListener changer = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                FontChooser.this.fireStateChange();
            }
        };
        this.font = DEFAULT_FONT.getFont();
        this.name.setModel(new CustomComboBoxModel());
        this.name.setRenderer(new CustomListCellRenderer());
        this.name.setSelectedItem(this.font.deriveFont(0, 16.0f));
        this.name.addItemListener(changer);
        this.size.setRenderer(new NumberCellRenderer());
        for (int i = 5; i <= 72; ++i) {
            this.size.addItem(new Integer(i));
        }
        this.size.setSelectedItem(new Integer(16));
        this.size.addItemListener(changer);
        this.bold.setSelected(this.font.isBold());
        this.bold.addItemListener(changer);
        this.italic.setSelected(this.font.isItalic());
        this.italic.addItemListener(changer);
        this.setLayout(new GridLayout(2, 2, 5, 5));
        this.add(this.name);
        this.add(this.size);
        this.add(this.bold);
        this.add(this.italic);
        GuiUtil.applyDefaultOrientation(this);
    }

    public static Font showDialog(Component parent, String title, Font initial) {
        final FontChooser fontc = new FontChooser();
        Component root = SwingUtilities.getRoot(parent);
        fontc.dialog = root instanceof JFrame ? new JDialog((JFrame)root, title, true) : new JDialog((JDialog)root, title, true);
        fontc.name.setSelectedItem(initial != null ? initial : DEFAULT_FONT.getFont());
        ActionFactory actions = new ActionFactory(FontChooser.class, fontc);
        JButton ok = actions.createJButton("OK", new ActionListener(){

            public void actionPerformed(ActionEvent ex) {
                fontc.dialog.setVisible(false);
            }
        });
        JButton cancel = actions.createJButton("Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent ex) {
                fontc.dialog.setVisible(false);
                fontc.font = null;
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(ok);
        buttons.add(cancel);
        fontc.setBorder(BorderFactory.createTitledBorder(UserMsg.SELECT_FONT.toString()));
        fontc.dialog.getRootPane().setDefaultButton(ok);
        fontc.dialog.getContentPane().setLayout(new BorderLayout());
        fontc.dialog.getContentPane().add((Component)fontc, "North");
        fontc.dialog.getContentPane().add((Component)buttons, "South");
        fontc.dialog.setSize(800, 500);
        fontc.dialog.pack();
        GuiUtil.centerOnScreen(fontc.dialog);
        GuiUtil.applyDefaultOrientation(fontc.dialog);
        fontc.dialog.setVisible(true);
        fontc.dialog.dispose();
        return fontc.font;
    }

    public void setStyle(Font newFont) {
        this.suppressEvents = true;
        if (newFont == null) {
            return;
        }
        CustomComboBoxModel model = (CustomComboBoxModel)this.name.getModel();
        model.setSelectedItem(newFont.deriveFont(0, 16.0f));
        this.bold.setSelected(newFont.isBold());
        this.italic.setSelected(newFont.isItalic());
        this.size.setSelectedItem(new Integer(newFont.getSize()));
        this.suppressEvents = false;
        this.fireStateChange();
    }

    public Font getStyle() {
        Font selected = (Font)this.name.getSelectedItem();
        if (selected == null) {
            return DEFAULT_FONT.getFont();
        }
        int font_style = (this.bold.isSelected() ? 1 : 0) | (this.italic.isSelected() ? 2 : 0);
        int font_size = (Integer)this.size.getSelectedItem();
        return selected.deriveFont(font_style, font_size);
    }

    protected void fireStateChange() {
        Font old = this.font;
        this.font = this.getStyle();
        if (!this.suppressEvents) {
            this.firePropertyChange(PROPERTY_STYLE, old, this.font);
        }
    }

    static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3256726195025358905L;

        public CustomListCellRenderer() {
            GuiUtil.applyDefaultOrientation(this);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean selected, boolean focus) {
            Font defaultFont = DEFAULT_FONT.getFont();
            if (value == null) {
                this.setText("<null>");
                this.setFont(defaultFont);
            } else {
                Font afont = (Font)value;
                this.setText(afont.getFamily());
                this.setFont(defaultFont);
            }
            return this;
        }
    }

    static class CustomComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int fontCount;
        private Font[] fonts;
        private Object selection;
        private static final long serialVersionUID = 3258129150505071664L;

        protected CustomComboBoxModel() {
            String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fonts = new Font[names.length];
            for (int i = 0; i < this.fonts.length; ++i) {
                if (names[i].equals("padmaa") || names[i].equals("Rekha") || names[i].indexOf("Lohit") > -1 || names[i].indexOf("aakar") > -1) continue;
                this.fonts[this.fontCount++] = new Font(names[i], 0, 16);
            }
        }

        public void setSelectedItem(Object selection) {
            this.selection = selection;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public int getSize() {
            return this.fontCount;
        }

        public Object getElementAt(int index) {
            return this.fonts[index];
        }
    }
}

