/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.SAXEventProviderInputSource;
import org.crosswire.common.xml.SAXEventProviderXMLReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TransformingSAXEventProvider
extends Transformer
implements SAXEventProvider {
    private ErrorListener errors;
    private URIResolver resolver;
    private Properties outputs = new Properties();
    private Map params = new HashMap();
    private URI xsluri;
    private SAXEventProvider xmlsep;
    private TransformerFactory transfact = TransformerFactory.newInstance();
    private static Map txers = new HashMap();
    private static final Logger log = Logger.getLogger(TransformingSAXEventProvider.class);

    public TransformingSAXEventProvider(URI xsluri, SAXEventProvider xmlsep) {
        this.xsluri = xsluri;
        this.xmlsep = xmlsep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateInfo getTemplateInfo() throws TransformerConfigurationException, IOException {
        long modtime = NetUtil.getLastModified(this.xsluri);
        TemplateInfo tinfo = (TemplateInfo)txers.get(this.xsluri);
        if (tinfo != null && modtime > tinfo.getModtime()) {
            txers.remove(this.xsluri);
            tinfo = null;
            log.debug("updated style, re-caching. xsl=" + this.xsluri);
        }
        if (tinfo == null) {
            log.debug("generating templates for " + this.xsluri);
            InputStream xslStream = null;
            try {
                xslStream = NetUtil.getInputStream(this.xsluri);
                Templates templates = this.transfact.newTemplates(new StreamSource(xslStream));
                tinfo = new TemplateInfo(templates, modtime);
                txers.put(this.xsluri, tinfo);
            }
            finally {
                IOUtil.close(xslStream);
            }
        }
        return tinfo;
    }

    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        String val;
        String key;
        TemplateInfo tinfo;
        try {
            tinfo = this.getTemplateInfo();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        Transformer transformer = tinfo.getTemplates().newTransformer();
        Iterator<Object> iter = this.outputs.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            val = this.getOutputProperty(key);
            transformer.setOutputProperty(key, val);
        }
        iter = this.params.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            val = this.params.get(key);
            transformer.setParameter(key, val);
        }
        if (this.errors != null) {
            transformer.setErrorListener(this.errors);
        }
        if (this.resolver != null) {
            transformer.setURIResolver(this.resolver);
        }
        transformer.transform(xmlSource, outputTarget);
    }

    public void provideSAXEvents(ContentHandler handler) throws SAXException {
        try {
            SAXSource xmlSource = new SAXSource(new SAXEventProviderXMLReader(this.xmlsep), new SAXEventProviderInputSource());
            SAXResult outputTarget = new SAXResult(handler);
            this.transform(xmlSource, outputTarget);
        }
        catch (TransformerException ex) {
            throw new SAXException(ex);
        }
    }

    public ErrorListener getErrorListener() {
        return this.errors;
    }

    public void setErrorListener(ErrorListener errors) throws IllegalArgumentException {
        this.errors = errors;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.resolver = resolver;
    }

    public Properties getOutputProperties() {
        return this.outputs;
    }

    public void setOutputProperties(Properties outputs) throws IllegalArgumentException {
        this.outputs = outputs;
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        return this.outputs.getProperty(name);
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        this.outputs.setProperty(name, value);
    }

    public void clearParameters() {
        this.params.clear();
    }

    public Object getParameter(String name) {
        return this.params.get(name);
    }

    public void setParameter(String name, Object value) {
        this.params.put(name, value);
    }

    private static class TemplateInfo {
        private Templates templates;
        private long modtime;

        public TemplateInfo(Templates templates, long modtime) {
            this.templates = templates;
            this.modtime = modtime;
        }

        Templates getTemplates() {
            return this.templates;
        }

        long getModtime() {
            return this.modtime;
        }
    }
}

