/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.TransformingSAXEventProvider;

public class XSLTProperty
implements Serializable {
    public static final XSLTProperty STRONGS_NUMBERS;
    public static final XSLTProperty MORPH;
    public static final XSLTProperty START_VERSE_ON_NEWLINE;
    public static final XSLTProperty VERSE_NUMBERS;
    public static final XSLTProperty CV;
    public static final XSLTProperty BCV;
    public static final XSLTProperty NO_VERSE_NUMBERS;
    public static final XSLTProperty TINY_VERSE_NUMBERS;
    public static final XSLTProperty HEADINGS;
    public static final XSLTProperty NOTES;
    public static final XSLTProperty XREF;
    public static final XSLTProperty BASE_URL;
    public static final XSLTProperty DIRECTION;
    public static final XSLTProperty FONT;
    public static final XSLTProperty CSS;
    private String name;
    private String defaultState;
    private String state;
    private boolean asURL;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final XSLTProperty[] VALUES;
    private static final long serialVersionUID = 3257567325749326905L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XSLTProperty(String name, boolean defaultState) {
        this(name, Boolean.toString(defaultState));
    }

    private XSLTProperty(String name, String defaultState) {
        this(name, defaultState, false);
    }

    private XSLTProperty(String name, String defaultState, boolean asURL) {
        this.name = name;
        this.defaultState = defaultState;
        this.state = defaultState;
        this.asURL = asURL;
    }

    public String getName() {
        return this.name;
    }

    public boolean getDefaultState() {
        return Boolean.valueOf(this.defaultState);
    }

    public String getDefaultStringState() {
        return this.defaultState;
    }

    public boolean getState() {
        return Boolean.valueOf(this.state);
    }

    public String getStringState() {
        return this.state;
    }

    public void setState(boolean newState) {
        this.state = Boolean.toString(newState);
    }

    public void setState(String newState) {
        this.state = newState;
    }

    public void setProperty(TransformingSAXEventProvider provider) {
        if (this.state != null && this.state.length() > 0) {
            String theState = this.state;
            if (this.asURL) {
                try {
                    theState = NetUtil.getURI((File)new File(this.state)).toURL().toString();
                }
                catch (MalformedURLException ex) {
                    Reporter.informUser((Object)this, (Throwable)ex);
                }
            }
            provider.setParameter(this.name, (Object)theState);
        }
    }

    public static void setProperties(TransformingSAXEventProvider provider) {
        for (int i = 0; i < VALUES.length; ++i) {
            VALUES[i].setProperty(provider);
        }
    }

    public static XSLTProperty fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            XSLTProperty o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static XSLTProperty fromInteger(int i) {
        return VALUES[i];
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !XSLTProperty.class.desiredAssertionStatus();
        STRONGS_NUMBERS = new XSLTProperty("Strongs", false);
        MORPH = new XSLTProperty("Morph", false);
        START_VERSE_ON_NEWLINE = new XSLTProperty("VLine", false);
        VERSE_NUMBERS = new XSLTProperty("VNum", true);
        CV = new XSLTProperty("CVNum", false);
        BCV = new XSLTProperty("BCVNum", false);
        NO_VERSE_NUMBERS = new XSLTProperty("NoVNum", false);
        TINY_VERSE_NUMBERS = new XSLTProperty("TinyVNum", true);
        HEADINGS = new XSLTProperty("Headings", true);
        NOTES = new XSLTProperty("Notes", true);
        XREF = new XSLTProperty("XRef", true);
        BASE_URL = new XSLTProperty("baseURL", "", true);
        DIRECTION = new XSLTProperty("direction", "");
        FONT = new XSLTProperty("font", "Serif-PLAIN-14");
        CSS = new XSLTProperty("css", "", true);
        VALUES = new XSLTProperty[]{STRONGS_NUMBERS, MORPH, START_VERSE_ON_NEWLINE, VERSE_NUMBERS, CV, BCV, NO_VERSE_NUMBERS, TINY_VERSE_NUMBERS, HEADINGS, NOTES, XREF, BASE_URL, DIRECTION, FONT, CSS};
    }
}

