/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.config.AbstractReflectedChoice;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.MappedChoice;
import org.crosswire.common.config.Msg;
import org.crosswire.common.config.StartupException;
import org.crosswire.common.util.Logger;
import org.jdom.Element;

public class MappedOptionsChoice
extends AbstractReflectedChoice
implements MappedChoice {
    private static Logger logger;
    private Map options;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(Element option, ResourceBundle configResources) throws StartupException {
        if (!$assertionsDisabled && configResources == null) {
            throw new AssertionError();
        }
        super.init(option, configResources);
        Element mapElement = option.getChild("map");
        if (mapElement == null) {
            throw new StartupException(Msg.CONFIG_NOMAP);
        }
        String name = mapElement.getAttributeValue("name");
        Object map = ChoiceFactory.getDataMap().get(name);
        this.options = map instanceof Map ? (Map)map : new TreeMap();
    }

    public Map getOptions() {
        return new TreeMap(this.options);
    }

    public Class getConversionClass() {
        return String.class;
    }

    public String convertToString(Object orig) {
        return orig != null ? orig.toString() : "";
    }

    public Object convertToObject(String orig) {
        Iterator iter = this.options.entrySet().iterator();
        Map.Entry mapEntry = null;
        while (iter.hasNext()) {
            mapEntry = iter.next();
            if (!mapEntry.getValue().toString().equals(orig) && !mapEntry.getKey().toString().equals(orig)) continue;
            return mapEntry.getKey().toString();
        }
        logger.warn(Msg.IGNORE.toString(orig));
        return "";
    }

    static {
        $assertionsDisabled = !MappedOptionsChoice.class.desiredAssertionStatus();
        logger = Logger.getLogger(MappedOptionsChoice.class);
    }
}

