/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.passage.KeyChangeEvent;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.bibledesktop.passage.RangeListModel;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseRange;

public class KeySidebar
extends JPanel
implements DisplaySelectListener,
KeyChangeListener {
    private static final String BLUR1 = "Blur1";
    private static final String BLUR5 = "Blur5";
    private static final String DELETE_SELECTED = "DeleteSelected";
    private Key key;
    private Key partial;
    private transient Book[] books;
    private transient List keyChangeListeners;
    private JList list;
    private RangeListModel model;
    private Action actDelete;
    private Action actBlur1;
    private Action actBlur5;
    private static final long serialVersionUID = 3905241217179466036L;

    public KeySidebar(Book[] books) {
        this.books = books == null ? null : (Book[])books.clone();
        this.init();
        this.setActive();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.model = new RangeListModel(RestrictionType.CHAPTER);
        this.list = new JList(this.model);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                KeySidebar.this.selection();
            }
        });
        CWScrollPane scroll = new CWScrollPane((Component)this.list);
        ActionFactory actions = new ActionFactory(KeySidebar.class, (Object)this);
        this.actDelete = actions.getAction(DELETE_SELECTED);
        this.actBlur1 = actions.getAction(BLUR1);
        this.actBlur5 = actions.getAction(BLUR5);
        JButton delete = new JButton(this.actDelete);
        delete.setText(null);
        JButton blur1 = new JButton(this.actBlur1);
        blur1.setText(null);
        JButton blur5 = new JButton(this.actBlur5);
        blur5.setText(null);
        JPanel mutate = new JPanel(new FlowLayout());
        mutate.add(delete);
        mutate.add(blur1);
        mutate.add(blur5);
        this.add((Component)mutate, "North");
        this.add((Component)scroll, "Center");
    }

    public void doBlur1() {
        this.doBlur(1);
    }

    public void doBlur5() {
        this.doBlur(5);
    }

    private void doBlur(int amount) {
        ArrayList<Object> selected = new ArrayList<Object>(Arrays.asList(this.list.getSelectedValues()));
        Key copy = (Key)this.key.clone();
        if (selected.isEmpty()) {
            copy.blur(amount, RestrictionType.getDefaultBlurRestriction());
        } else {
            Iterator iter = selected.iterator();
            while (iter.hasNext()) {
                Key k = (Key)iter.next();
                Key keyCopy = (Key)k.clone();
                keyCopy.blur(amount, RestrictionType.getDefaultBlurRestriction());
                copy.addAll(keyCopy);
            }
        }
        this.fireKeyChanged(new KeyChangeEvent(this, copy));
        int total = this.model.getSize();
        for (int i = 0; i < total; ++i) {
            Key listedKey = (Key)this.model.getElementAt(i);
            Iterator iter = selected.iterator();
            while (iter.hasNext()) {
                Key selectedKey = (Key)iter.next();
                if (!listedKey.contains(selectedKey)) continue;
                this.list.addSelectionInterval(i, i);
                iter.remove();
            }
            if (selected.size() == 0) break;
        }
        GuiUtil.refresh((Component)this);
    }

    public void doDeleteSelected() {
        RangeListModel rlm = (RangeListModel)this.list.getModel();
        Passage ref = rlm.getPassage();
        Object[] selected = this.list.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            VerseRange range = (VerseRange)selected[i];
            ref.remove((Key)range);
        }
        this.list.setSelectedIndices(new int[0]);
        this.partial = null;
        this.model.setPassage((Passage)this.key);
        this.fireKeyChanged(new KeyChangeEvent(this, this.key));
        this.setActive();
    }

    public Key getKey() {
        return this.key;
    }

    private void setKey(Key newKey) {
        if (this.partial != null && this.partial.equals(newKey)) {
            return;
        }
        if (this.key != null && this.key.equals(newKey)) {
            return;
        }
        if (newKey == null) {
            this.key = null;
        } else if (this.key != newKey) {
            this.key = (Key)newKey.clone();
        }
        this.partial = null;
        this.model.setPassage((Passage)this.key);
        this.fireKeyChanged(new KeyChangeEvent(this, this.key));
        this.setActive();
    }

    final void selection() {
        Object[] selected = this.list.getSelectedValues();
        if (selected.length > 0) {
            this.partial = this.books[0].createEmptyKeyList();
            for (int i = 0; i < selected.length; ++i) {
                this.partial.addAll((Key)selected[i]);
            }
            this.fireKeyChanged(new KeyChangeEvent(this, this.partial));
        } else {
            this.fireKeyChanged(new KeyChangeEvent(this, this.key));
        }
        this.setActive();
    }

    private void setActive() {
        Object[] selected = this.list.getSelectedValues();
        this.actDelete.setEnabled(selected.length != 0);
        boolean blurable = this.model.getSize() != 0;
        this.actBlur1.setEnabled(blurable);
        this.actBlur5.setEnabled(blurable);
    }

    public void passageSelected(DisplaySelectEvent ev) {
        this.setKey(ev.getKey());
    }

    public void bookChosen(DisplaySelectEvent ev) {
        this.books = ev.getBookProvider().getBooks();
    }

    public void keyChanged(KeyChangeEvent ev) {
        this.setKey(ev.getKey());
    }

    public synchronized void addKeyChangeListener(KeyChangeListener listener) {
        ArrayList<KeyChangeListener> temp = new ArrayList<KeyChangeListener>(2);
        if (this.keyChangeListeners != null) {
            temp.addAll(this.keyChangeListeners);
        }
        if (!temp.contains(listener)) {
            temp.add(listener);
            this.keyChangeListeners = temp;
        }
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener listener) {
        if (this.keyChangeListeners != null && this.keyChangeListeners.contains(listener)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.keyChangeListeners);
            temp.remove(listener);
            this.keyChangeListeners = temp;
        }
    }

    final synchronized void fireKeyChanged(KeyChangeEvent ev) {
        if (this.keyChangeListeners != null) {
            for (int i = 0; i < this.keyChangeListeners.size(); ++i) {
                KeyChangeListener li = (KeyChangeListener)this.keyChangeListeners.get(i);
                li.keyChanged(ev);
            }
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.books = null;
        this.keyChangeListeners = null;
        is.defaultReadObject();
    }
}

