/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import javax.swing.Icon;
import org.crosswire.common.swing.CompositeIcon;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;

public class BookIcon {
    private static final Icon ICON_BIBLE = GuiUtil.getIcon((String)"images/book-b16.png");
    private static final Icon ICON_COMNT = GuiUtil.getIcon((String)"images/book-c16.png");
    private static final Icon ICON_DICT = GuiUtil.getIcon((String)"images/book-d16.png");
    private static final Icon ICON_READ = GuiUtil.getIcon((String)"images/book-r16.png");
    private static final Icon ICON_GLOSS = GuiUtil.getIcon((String)"images/book-g16.png");
    private static final Icon ICON_OTHER = GuiUtil.getIcon((String)"images/book-o16.png");
    private static final Icon ICON_QUESTIONABLE = GuiUtil.getIcon((String)"images/overlay-q16.png");
    private static final Icon ICON_LOCKED = GuiUtil.getIcon((String)"images/overlay-lock16.png");
    private static final Icon ICON_UNSUPPORTED = GuiUtil.getIcon((String)"images/overlay-x16.png");

    private BookIcon() {
    }

    public static Icon getIcon(Book book) {
        Icon icon = ICON_OTHER;
        BookCategory type = book.getBookCategory();
        icon = type.equals((Object)BookCategory.BIBLE) ? ICON_BIBLE : (type.equals((Object)BookCategory.COMMENTARY) ? ICON_COMNT : (type.equals((Object)BookCategory.DICTIONARY) ? ICON_DICT : (type.equals((Object)BookCategory.GLOSSARY) ? ICON_GLOSS : (type.equals((Object)BookCategory.DAILY_DEVOTIONS) ? ICON_READ : ICON_OTHER))));
        if (book.isQuestionable()) {
            icon = new CompositeIcon(icon, ICON_QUESTIONABLE, 0);
        }
        if (!book.isSupported()) {
            icon = new CompositeIcon(icon, ICON_UNSUPPORTED, 0);
        } else if (book.isLocked()) {
            icon = new CompositeIcon(icon, ICON_LOCKED, 0);
        }
        return icon;
    }
}

